/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.util.InjectionUtils;
import org.slf4j.Logger;

public final class ConnectionUtils {
    private ConnectionUtils() {
    }

    public static RetryPolicyTemplate getRetryPolicyTemplate(Optional<ReconnectionConfig> reconnectionConfig) {
        return reconnectionConfig.map(ReconnectionConfig::getRetryPolicyTemplate).orElseGet(NoRetryPolicyTemplate::new);
    }

    public static <C> C connect(ConnectionProvider<C> delegate) throws ConnectionException {
        try {
            return delegate.connect();
        }
        catch (ConnectionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public static <C> ConnectionProvider<C> unwrap(ConnectionProvider<C> connectionProvider) {
        while (connectionProvider instanceof ConnectionProviderWrapper) {
            connectionProvider = ((ConnectionProviderWrapper)connectionProvider).getDelegate();
        }
        return connectionProvider;
    }

    public static <C> Object getInjectionTarget(ConnectionProvider<C> connectionProvider) {
        return InjectionUtils.getInjectionTarget(ConnectionUtils.unwrap(connectionProvider));
    }

    public static <C> void logPoolStatus(Logger logger, GenericObjectPool<C> pool, String poolId) {
        if (logger.isDebugEnabled()) {
            String maxActive = pool.getMaxTotal() < 0 || pool.getMaxTotal() == Integer.MAX_VALUE ? "unlimited" : String.valueOf(pool.getMaxTotal());
            String maxIdle = pool.getMaxIdle() < 0 ? "unlimited" : String.valueOf(pool.getMaxIdle());
            logger.debug("Status for pool {}: {} connections are active out of {} max active limit, {} connections are idle out of {} max idle limit", new Object[]{poolId, pool.getNumActive(), maxActive, pool.getNumIdle(), maxIdle});
        }
    }
}

