/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.dataweave;

import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageConfiguration;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.el.validation.ScopePhaseValidationMessages;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.el.DefaultBindingContextBuilder;
import org.mule.runtime.core.internal.el.ExpressionLanguageSessionAdaptor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.IllegalCompiledExpression;
import org.mule.runtime.core.internal.el.context.MuleInstanceContext;
import org.mule.runtime.core.internal.el.context.ServerContext;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveArtifactContext;

public class DataWeaveExpressionLanguageAdaptor
implements ExtendedExpressionLanguageAdaptor,
Disposable {
    public static final String SERVER = "server";
    public static final String MULE = "mule";
    public static final String APP = "app";
    private final ExpressionLanguage expressionExecutor;
    private final MuleContext muleContext;

    @Inject
    public DataWeaveExpressionLanguageAdaptor(MuleContext muleContext, Registry registry, DefaultExpressionLanguageFactoryService service, FeatureFlaggingService featureFlaggingService) {
        this.expressionExecutor = service.create(ExpressionLanguageConfiguration.builder().defaultEncoding(SystemUtils.getDefaultEncoding(muleContext)).featureFlaggingService(featureFlaggingService).appId(muleContext.getConfiguration().getId()).minMuleVersion(muleContext.getConfiguration().getMinMuleVersion()).build());
        this.muleContext = muleContext;
        this.registerGlobalBindings(registry);
    }

    private void registerGlobalBindings(Registry registry) {
        BindingContext.Builder contextBuilder = BindingContext.builder();
        contextBuilder.addBinding(MULE, new TypedValue<MuleInstanceContext>(new MuleInstanceContext(this.muleContext), DataType.fromType(MuleInstanceContext.class)));
        contextBuilder.addBinding(SERVER, new TypedValue<ServerContext>(new ServerContext(), DataType.fromType(ServerContext.class)));
        contextBuilder.addBinding(APP, new TypedValue<DataWeaveArtifactContext>(new DataWeaveArtifactContext(this.muleContext, registry), DataType.fromType(DataWeaveArtifactContext.class)));
        this.addGlobalBindings(contextBuilder instanceof DefaultBindingContextBuilder ? ((DefaultBindingContextBuilder)contextBuilder).flattenAndBuild() : contextBuilder.build());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionExecutor.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, BindingContext context) {
        String sanitized = ExpressionLanguageUtils.sanitize(expression);
        if (ExpressionLanguageUtils.isSanitizedPayload(sanitized)) {
            return event.getMessage().getPayload();
        }
        BindingContext newContext = this.bindingContextFor(null, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, newContext));
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        BindingContext newContext = this.bindingContextFor(null, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, newContext));
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        BindingContext newContext = this.bindingContextFor(componentLocation, event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, newContext));
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, componentLocation, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext context) {
        String sanitized = ExpressionLanguageUtils.sanitize(expression);
        if (ExpressionLanguageUtils.isSanitizedPayload(sanitized)) {
            return DataWeaveExpressionLanguageAdaptor.resolvePayload(event, context);
        }
        BindingContext newContext = this.bindingContextFor(componentLocation, event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, newContext));
    }

    @Override
    public CompiledExpression compile(String expression, BindingContext bindingContext) {
        try {
            return this.expressionExecutor.compile(ExpressionLanguageUtils.sanitize(expression), bindingContext);
        }
        catch (ExpressionCompilationException e) {
            if (this.badExpressionFailsDeployment()) {
                throw e;
            }
            return new IllegalCompiledExpression(expression, e);
        }
    }

    @Override
    public ScopePhaseValidationMessages collectScopePhaseValidationMessages(String script, String nameIdentifier, TypeBindings bindings) {
        return this.expressionExecutor.collectScopePhaseValidationMessages(script, nameIdentifier, bindings);
    }

    private boolean badExpressionFailsDeployment() {
        return System.getProperty("mule.expressionCompilationFailDeployment") != null;
    }

    protected static TypedValue resolvePayload(CoreEvent event, BindingContext context) {
        return event != null ? event.getMessage().getPayload() : (context != null ? (TypedValue)context.lookup("payload").orElse(null) : null);
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        try {
            return this.expressionExecutor.evaluateLogExpression(ExpressionLanguageUtils.sanitize(expression), this.bindingContextFor(componentLocation, event, bindingContext));
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(ExpressionLanguageUtils.sanitize(expression));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext context = this.bindingContextFor(componentLocation, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, context));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext context = this.bindingContextFor(null, event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, context));
    }

    private <T> T sanitizeAndEvaluate(String expression, Function<String, T> evaluation) {
        return this.evaluate(ExpressionLanguageUtils.sanitize(expression), evaluation);
    }

    private <T> T evaluate(String expression, Function<String, T> evaluation) {
        try {
            return evaluation.apply(expression);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    private BindingContext bindingContextFor(ComponentLocation componentLocation, CoreEvent event, BindingContext context) {
        if (event == null && componentLocation == null) {
            return context;
        }
        BindingContext.Builder contextBuilder = event != null ? BindingContextUtils.addEventBuindingsToBuilder(event, context) : BindingContext.builder(context);
        if (componentLocation != null) {
            contextBuilder = BindingContextUtils.addFlowNameBindingsToBuilder(componentLocation, contextBuilder);
        }
        return contextBuilder.build();
    }

    @Override
    public void dispose() {
        this.expressionExecutor.dispose();
    }

    @Override
    public ExpressionLanguageSessionAdaptor openSession(ComponentLocation location, final CoreEvent event, BindingContext baseContext) {
        final BindingContext context = this.bindingContextFor(location, event, baseContext);
        final ExpressionLanguageSession session = this.expressionExecutor.openSession(context);
        return new ExpressionLanguageSessionAdaptor(){

            @Override
            public TypedValue<?> evaluate(String expression) throws ExpressionRuntimeException {
                String sanitized = ExpressionLanguageUtils.sanitize(expression);
                if (ExpressionLanguageUtils.isSanitizedPayload(sanitized)) {
                    return DataWeaveExpressionLanguageAdaptor.resolvePayload(event, context);
                }
                try {
                    return session.evaluate(sanitized);
                }
                catch (ExpressionExecutionException e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), sanitized), (Throwable)e);
                }
            }

            @Override
            public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionRuntimeException {
                String sanitized = ExpressionLanguageUtils.sanitize(expression);
                if (ExpressionLanguageUtils.isSanitizedPayload(sanitized)) {
                    return DataWeaveExpressionLanguageAdaptor.resolvePayload(event, context);
                }
                try {
                    return session.evaluate(sanitized, timeout);
                }
                catch (ExpressionExecutionException e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), sanitized), (Throwable)e);
                }
            }

            @Override
            public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionRuntimeException {
                String sanitized = ExpressionLanguageUtils.sanitize(expression);
                try {
                    return session.evaluate(sanitized, expectedOutputType);
                }
                catch (ExpressionExecutionException e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), sanitized), (Throwable)e);
                }
            }

            @Override
            public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionRuntimeException {
                String sanitized = ExpressionLanguageUtils.sanitize(expression);
                try {
                    return session.evaluateLogExpression(sanitized);
                }
                catch (ExpressionExecutionException e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), sanitized), (Throwable)e);
                }
            }

            @Override
            public Iterator<TypedValue<?>> split(String expression) {
                return session.split(ExpressionLanguageUtils.sanitize(expression));
            }

            private RuntimeException handledException(CompiledExpression expression, Exception e) {
                if (expression instanceof IllegalCompiledExpression) {
                    ExpressionCompilationException original = ((IllegalCompiledExpression)expression).getCompilationException();
                    return new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(original.getMessage(), expression.expression()), (Throwable)original);
                }
                return new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression.expression()), (Throwable)e);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression) throws ExpressionExecutionException {
                if (ExpressionLanguageUtils.isSanitizedPayload(expression.expression())) {
                    return DataWeaveExpressionLanguageAdaptor.resolvePayload(event, context);
                }
                try {
                    return session.evaluate(expression);
                }
                catch (Exception e) {
                    throw this.handledException(expression, e);
                }
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, DataType expectedOutputType) throws ExpressionExecutionException {
                try {
                    return session.evaluate(expression, expectedOutputType);
                }
                catch (Exception e) {
                    throw this.handledException(expression, e);
                }
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, long timeout) throws ExpressionExecutionException {
                if (ExpressionLanguageUtils.isSanitizedPayload(expression.expression())) {
                    return DataWeaveExpressionLanguageAdaptor.resolvePayload(event, context);
                }
                try {
                    return session.evaluate(expression, timeout);
                }
                catch (Exception e) {
                    throw this.handledException(expression, e);
                }
            }

            @Override
            public TypedValue<?> evaluateLogExpression(CompiledExpression expression) throws ExpressionExecutionException {
                try {
                    return session.evaluateLogExpression(expression);
                }
                catch (Exception e) {
                    throw this.handledException(expression, e);
                }
            }

            @Override
            public Iterator<TypedValue<?>> split(CompiledExpression expression) {
                try {
                    return session.split(expression);
                }
                catch (Exception e) {
                    throw this.handledException(expression, e);
                }
            }

            @Override
            public void close() {
                session.close();
            }
        };
    }
}

