/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.util.CompoundEnumeration;

@Deprecated
public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> delegates;
    private static final Cache<List<Integer>, CompositeClassLoader> cache;

    CompositeClassLoader(ClassLoader first, ClassLoader second) {
        this.delegates = first != null && second != null ? Collections.unmodifiableList(Arrays.asList(first, second)) : (first != null ? Collections.unmodifiableList(Collections.singletonList(first)) : (second != null ? Collections.unmodifiableList(Collections.singletonList(second)) : Collections.unmodifiableList(Collections.emptyList())));
    }

    CompositeClassLoader(ClassLoader ... classLoaders) {
        this.delegates = new ArrayList<ClassLoader>(classLoaders.length);
        for (ClassLoader cl : classLoaders) {
            if (cl == null) continue;
            this.delegates.add(cl);
        }
        this.delegates = Collections.unmodifiableList(this.delegates);
    }

    public static CompositeClassLoader from(ClassLoader ... classLoaders) {
        List<Integer> key = CompositeClassLoader.getKey(classLoaders);
        return (CompositeClassLoader)cache.get(key, id -> new CompositeClassLoader(classLoaders));
    }

    public static CompositeClassLoader from(ClassLoader first, ClassLoader second) {
        List<Integer> key = CompositeClassLoader.getKey(first, second);
        return (CompositeClassLoader)cache.get(key, id -> new CompositeClassLoader(first, second));
    }

    private static List<Integer> getKey(ClassLoader ... classLoaders) {
        ArrayList<Integer> key = new ArrayList<Integer>(classLoaders.length);
        for (ClassLoader cl : classLoaders) {
            if (cl == null) continue;
            key.add(System.identityHashCode(cl));
        }
        return key;
    }

    private static List<Integer> getKey(ClassLoader first, ClassLoader second) {
        if (first != null && second != null) {
            return Arrays.asList(System.identityHashCode(first), System.identityHashCode(second));
        }
        if (first != null) {
            return Collections.singletonList(System.identityHashCode(first));
        }
        if (second != null) {
            return Collections.singletonList(System.identityHashCode(second));
        }
        return Collections.emptyList();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve2) throws ClassNotFoundException {
        ClassNotFoundException firstException = null;
        for (ClassLoader classLoader : this.delegates) {
            try {
                Class<?> result = classLoader.loadClass(name);
                if (resolve2) {
                    this.resolveClass(result);
                }
                return result;
            }
            catch (ClassNotFoundException e) {
                firstException = e;
            }
        }
        throw firstException;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.delegates) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(name);
            if (resourceAsStream == null) continue;
            return resourceAsStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[this.delegates.size()];
        int i = 0;
        for (ClassLoader classLoader : this.delegates) {
            tmp[i++] = classLoader.getResources(name);
        }
        return new CompoundEnumeration<URL>(tmp);
    }

    public List<ClassLoader> getDelegates() {
        return this.delegates;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.delegates.toString();
    }

    static {
        CompositeClassLoader.registerAsParallelCapable();
        cache = Caffeine.newBuilder().maximumSize(1024L).weakValues().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }
}

