/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.splash;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.util.splash.PropertyChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SplashScreen {
    public static Logger LOGGER = LoggerFactory.getLogger(SplashScreen.class);
    public static final String RUNTIME_VERBOSE = "mule.runtime.verbose";
    public static final String CUSTOM_NAMES = "mule.splash.masked.properties";
    private static final List<String> CREDENTIAL_NAMES = ImmutableList.of((Object)"key", (Object)"password", (Object)"pswd");
    private static final Set<String> CUSTOM_CREDENTIAL_NAMES = new HashSet<String>(Arrays.asList(System.getProperty("mule.splash.masked.properties", "").split(",")));
    public static final String CREDENTIAL_MASK = "*****";
    protected static PropertyChecker RUNTIME_VERBOSE_PROPERTY = new PropertyChecker("mule.runtime.verbose", Boolean.TRUE.toString());
    protected static final String VALUE_FORMAT = " - %s";
    private static final String KEY_VALUE_FORMAT = " - %s = %s";
    protected List<String> header = new ArrayList<String>();
    protected List<String> body = new ArrayList<String>();
    protected List<String> footer = new ArrayList<String>();

    public final void setHeader(MuleContext context) {
        this.header.clear();
        this.doHeader(context);
    }

    public final void addBody(String line) {
        this.doBody(line);
    }

    public final void setFooter(MuleContext context) {
        this.footer.clear();
        this.doFooter(context);
    }

    public static String miniSplash(String message) {
        return StringMessageUtils.getBoilerPlate(message, '+', 80);
    }

    protected void doHeader(MuleContext context) {
    }

    protected void doBody(String line) {
        this.body.add(line);
    }

    protected void doFooter(MuleContext context) {
    }

    protected void listItems(Collection<String> items, String description) {
        if (!items.isEmpty()) {
            this.doBody(description);
            for (String item : items) {
                this.doBody(String.format(VALUE_FORMAT, item));
            }
        }
    }

    private boolean isCredentialItem(String key) {
        if (CUSTOM_CREDENTIAL_NAMES.contains(key)) {
            return true;
        }
        for (String credentialName : CREDENTIAL_NAMES) {
            if (!key.toLowerCase().contains(credentialName)) continue;
            return true;
        }
        return false;
    }

    protected void listItems(Map<String, String> map, String description) {
        if (!map.isEmpty()) {
            this.doBody(description);
            for (String key : map.keySet()) {
                String value = this.isCredentialItem(key) ? CREDENTIAL_MASK : map.get(key);
                this.doBody(String.format(KEY_VALUE_FORMAT, key, value));
            }
        }
    }

    public String toString() {
        ArrayList<String> boilerPlate = new ArrayList<String>(this.header);
        boilerPlate.addAll(this.body);
        boilerPlate.addAll(this.footer);
        return StringMessageUtils.getBoilerPlate(boilerPlate, '*', 70);
    }

    protected SplashScreen() {
    }
}

