/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class DefaultRegionPluginClassLoadersFactory
implements RegionPluginClassLoadersFactory {
    public static final String PLUGIN_CLASSLOADER_IDENTIFIER = "/plugin/";
    private final ArtifactClassLoaderResolver artifactClassLoaderResolver;

    public DefaultRegionPluginClassLoadersFactory(ArtifactClassLoaderResolver artifactClassLoaderResolver) {
        this.artifactClassLoaderResolver = Objects.requireNonNull(artifactClassLoaderResolver);
    }

    @Override
    public List<ArtifactClassLoader> createPluginClassLoaders(ArtifactClassLoader regionClassLoader, List<ArtifactPluginDescriptor> artifactPluginDescriptors, ClassLoaderLookupPolicy regionOwnerLookupPolicy) {
        LinkedList<ArtifactClassLoader> classLoaders = new LinkedList<ArtifactClassLoader>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : artifactPluginDescriptors) {
            MuleArtifactClassLoader artifactClassLoader = this.artifactClassLoaderResolver.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)((RegionClassLoader)regionClassLoader).getOwnerClassLoader(), artifactPluginDescriptor, (pluginDescriptors, bundleDescriptor) -> artifactPluginDescriptors.stream().filter(apd -> apd.getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) && apd.getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())).findAny(), (ownerArtifactClassLoader, dependencyPluginDescriptor) -> Optional.of(() -> classLoaders.stream().filter(c -> ((ArtifactDescriptor)c.getArtifactDescriptor()).getBundleDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId())).findAny().get()));
            classLoaders.add(artifactClassLoader);
        }
        return classLoaders;
    }

    public static String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)parentArtifactId), "parentArtifactId cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)pluginName), "pluginName cannot be empty");
        return parentArtifactId + PLUGIN_CLASSLOADER_IDENTIFIER + pluginName;
    }
}

