/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.jpms.api;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JpmsUtils {
    public static final String MULE_SKIP_MODULE_TWEAKING_VALIDATION = "mule.module.tweaking.validation.skip";
    private static final String REQUIRED_ADD_MODULES = "--add-modules=java.se,org.mule.boot.tanuki,org.mule.runtime.jpms.utils,com.fasterxml.jackson.core";
    private static final String REQUIRED_CE_BOOT_ADD_READS = "--add-reads=org.mule.boot.tanuki=org.mule.boot";
    private static final String REQUIRED_BOOT_ADD_READS = "--add-reads=org.mule.boot.tanuki=com.mulesoft.mule.boot";
    private static final String REQUIRED_CE_BOOT_ADD_EXPORTS = "--add-exports=org.mule.boot/org.mule.runtime.module.reboot=ALL-UNNAMED";
    private static final String REQUIRED_BOOT_ADD_EXPORTS = "--add-exports=com.mulesoft.mule.boot/org.mule.runtime.module.reboot=ALL-UNNAMED";
    private static final String REQUIRED_ADD_OPENS = "--add-opens=java.base/java.lang=org.mule.runtime.jpms.utils";
    private static final Set<String> SERVICE_MODULE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("org.mule.service.", "com.mulesoft.mule.service."));

    private JpmsUtils() {
    }

    public static void validateNoBootModuleLayerTweaking() {
        if (Boolean.getBoolean(MULE_SKIP_MODULE_TWEAKING_VALIDATION)) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("!! WARNING!");
            System.err.println("!! 'mule.module.tweaking.validation.skip' property MUST ONLY be used temporarily in development environments.");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        List illegalArguments = arguments.stream().filter(arg -> arg.startsWith("--add-exports") || arg.startsWith("--add-opens") || arg.startsWith("--add-modules") || arg.startsWith("--add-reads") || arg.startsWith("--patch-module")).filter(arg -> !arg.equals(REQUIRED_ADD_MODULES) && !arg.equals(REQUIRED_CE_BOOT_ADD_READS) && !arg.equals(REQUIRED_BOOT_ADD_READS) && !arg.equals(REQUIRED_CE_BOOT_ADD_EXPORTS) && !arg.equals(REQUIRED_BOOT_ADD_EXPORTS) && !arg.equals(REQUIRED_ADD_OPENS)).collect(Collectors.toList());
        if (!illegalArguments.isEmpty()) {
            throw new IllegalArgumentException("Invalid module tweaking options passed to the JVM running the Mule Runtime: " + illegalArguments);
        }
    }

    public static void exploreJdkModules(Set<String> packages) {
        ModuleLayer.boot().modules().stream().filter(module -> {
            String moduleName = module.getName();
            return moduleName.startsWith("java.") || moduleName.startsWith("jdk.");
        }).forEach(module -> packages.addAll(module.getPackages()));
    }

    public static ModuleLayer createModuleLayer(URL[] modulePathEntries, ClassLoader parent, Optional<ModuleLayer> parentLayer, boolean isolateDependenciesInTheirOwnLayer, boolean filterBootModules) {
        ModuleLayer.Controller controller;
        Set bootModules = filterBootModules ? ModuleLayer.boot().modules().stream().map(m -> m.getName()).collect(Collectors.toSet()) : Collections.emptySet();
        Path[] paths = (Path[])Stream.of(modulePathEntries).map(url -> {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Path[]::new);
        ModuleFinder modulesFinder = ModuleFinder.of(paths);
        Map<Boolean, List<ModuleReference>> modulesByAutomatic = modulesFinder.findAll().stream().filter(moduleRef -> !bootModules.contains(moduleRef.descriptor().name())).collect(Collectors.partitioningBy(moduleRef -> JpmsUtils.isolateInOrphanLayer((ModuleReference)moduleRef, (Optional)parentLayer)));
        ModuleLayer resolvedParentLayer = parentLayer.orElse(ModuleLayer.boot());
        if (isolateDependenciesInTheirOwnLayer) {
            Path[] automaticModulesPaths = (Path[])modulesByAutomatic.get(true).stream().map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder automaticModulesFinder = ModuleFinder.of(automaticModulesPaths);
            Configuration automaticModulesConfiguration = ModuleLayer.boot().configuration().resolve(automaticModulesFinder, ModuleFinder.ofSystem(), modulesByAutomatic.get(true).stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList()));
            ModuleLayer.Controller automaticModulesController = ModuleLayer.defineModulesWithOneLoader(automaticModulesConfiguration, Collections.singletonList(ModuleLayer.boot()), parentLayer.map(layer -> layer.findLoader(layer.modules().iterator().next().getName())).orElse(parent));
            Path[] notAutomaticModulesPaths = (Path[])modulesByAutomatic.get(false).stream().map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder notAutomaticModulesFinder = ModuleFinder.of(notAutomaticModulesPaths);
            Configuration configuration = Configuration.resolve(notAutomaticModulesFinder, Arrays.asList(automaticModulesController.layer().configuration(), resolvedParentLayer.configuration()), ModuleFinder.ofSystem(), modulesByAutomatic.get(false).stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList()));
            controller = ModuleLayer.defineModulesWithOneLoader(configuration, Arrays.asList(automaticModulesController.layer(), resolvedParentLayer), parentLayer.map(layer -> layer.findLoader(layer.modules().iterator().next().getName())).orElse(parent));
        } else {
            Path[] filteredModulesPaths = (Path[])modulesByAutomatic.values().stream().flatMap(Collection::stream).map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder filteredModulesFinder = ModuleFinder.of(filteredModulesPaths);
            Configuration configuration = resolvedParentLayer.configuration().resolve(filteredModulesFinder, ModuleFinder.ofSystem(), modulesByAutomatic.values().stream().flatMap(Collection::stream).map(modueRef -> modueRef.descriptor().name()).collect(Collectors.toList()));
            controller = ModuleLayer.defineModulesWithOneLoader(configuration, Collections.singletonList(resolvedParentLayer), parentLayer.map(layer -> layer.findLoader(layer.modules().iterator().next().getName())).orElse(parent));
        }
        return controller.layer();
    }

    private static boolean isolateInOrphanLayer(ModuleReference moduleRef, Optional<ModuleLayer> containerLayer) {
        if (moduleRef.descriptor().isAutomatic()) {
            if (SERVICE_MODULE_NAME_PREFIXES.stream().noneMatch(moduleRef.descriptor().name()::startsWith)) {
                return true;
            }
        }
        Set containerModuleNames = containerLayer.map(layer -> layer.modules().stream().map(Module::getName).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return containerLayer.map(layer -> moduleRef.descriptor().requires().stream().noneMatch(req -> containerModuleNames.contains(req.name()))).orElse(false);
    }

    public static void openToModule(ModuleLayer layer, String moduleName, String bootModuleName, List<String> packages) {
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getName();
        if (!callerClassName.equals("org.mule.runtime.module.service.api.artifact.ServiceModuleLayerFactory") && !callerClassName.equals("org.mule.runtime.jpms.api.JpmsUtils")) {
            throw new UnsupportedOperationException("This is for internal use only.");
        }
        layer.findModule(moduleName).ifPresent(module -> {
            Module bootModule = ModuleLayer.boot().findModule(bootModuleName).get();
            for (String pkg : packages) {
                bootModule.addOpens(pkg, (Module)module);
            }
        });
    }
}

