/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.config.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.metrics.exporter.config.api.MeterExporterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMeterExporterConfiguration
implements MeterExporterConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMeterExporterConfiguration.class);
    private static final String CONFIGURATION_FILE_NAME = "meter-exporter.conf";
    private final MuleContext muleContext;
    private JsonNode configuration;
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final ConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());

    public FileMeterExporterConfiguration(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.getMeterExporterProperties();
    }

    @Override
    public String getStringValue(String key) {
        String value = this.readStringFromConfigOrSystemProperty(key);
        if (value != null) {
            String absolutePath;
            value = this.propertyResolver.apply(value);
            if (this.isAValueCorrespondingToAPath(key) && (absolutePath = this.getAbsolutePath(value)) != null) {
                return absolutePath;
            }
        }
        return value;
    }

    private String readStringFromConfigOrSystemProperty(String key) {
        if (this.configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = this.configuration;
            for (int i = 0; i < path.length && configurationValue.get(path[i]) != null; ++i) {
                configurationValue = configurationValue.get(path[i]);
            }
            return configurationValue != null && !configurationValue.asText().isEmpty() ? configurationValue.asText() : null;
        }
        return System.getProperty(key);
    }

    private boolean isAValueCorrespondingToAPath(String key) {
        return key.equals("mule.openTelemetry.meter.exporter.tls.caFileLocation") || key.equals("mule.openTelemetry.meter.exporter.tls.keyFileLocation");
    }

    private String getAbsolutePath(String value) {
        Path path = Paths.get(value, new String[0]);
        try {
            URL url;
            if (!path.isAbsolute() && (url = this.getExecutionClassLoader(this.muleContext).getResource(value)) != null) {
                return new File(url.toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            return value;
        }
        return null;
    }

    private void getMeterExporterProperties() {
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        try {
            InputStream is = resourceProvider.getResourceAsStream(this.resolveConfigurationFilePath());
            this.configuration = FileMeterExporterConfiguration.loadConfiguration(is);
        }
        catch (IOException | MuleRuntimeException e) {
            LOGGER.info("No meter exporter configuration found.");
        }
    }

    private String resolveConfigurationFilePath() {
        String defaultConfigurationFilePath = this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName();
        return System.getProperty("mule.openTelemetry.meter.exporter.configurationFilePath", defaultConfigurationFilePath);
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    protected String getConfFolder() {
        return MuleFoldersUtil.getConfFolder().getAbsolutePath();
    }

    protected String getPropertiesFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    private static JsonNode loadConfiguration(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull("input stream");
            throw new IOException(error.toString());
        }
        try {
            JsonNode jsonNode = configFileMapper.readTree(is);
            return jsonNode;
        }
        finally {
            is.close();
        }
    }
}

