/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.VersionUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginLocalDependenciesDenylist;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactAttributes;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.DependencyConverter;
import org.mule.runtime.module.deployment.impl.internal.maven.HeavyweightClassLoaderConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.LightweightClassLoaderConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleArtifactPatchingModel;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenClassLoaderConfigurationLoader
implements ClassLoaderConfigurationLoader {
    public static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR = "classloader-model.json";
    public static final String CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR = "classloader-model-patch.json";
    public static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "classloader-model.json").toString();
    public static final String CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "classloader-model-patch.json").toString();
    public static final String MULE_ARTIFACT_PATCHES_LOCATION = Paths.get("lib/patches/mule-artifact-patches", new String[0]).toString();
    public static final String MULE_ARTIFACT_PATCH_JSON_FILE_NAME = "mule-artifact-patch.json";
    public static final String CLASSLOADER_MODEL_MAVEN_REACTOR_RESOLVER = "_classLoaderModelMavenReactorResolver";
    public static final String CLASS_LOADER_MODEL_VERSION_120 = "1.2.0";
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Optional<MavenClient> mavenClient;
    private final Supplier<JarExplorer> jarExplorerFactory;

    public AbstractMavenClassLoaderConfigurationLoader(Optional<MavenClient> mavenClient) {
        this(mavenClient, () -> new FileJarExplorer());
    }

    public AbstractMavenClassLoaderConfigurationLoader(Optional<MavenClient> mavenClient, Supplier<JarExplorer> jarExplorerFactory) {
        this.mavenClient = mavenClient;
        this.jarExplorerFactory = jarExplorerFactory;
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public final ClassLoaderConfiguration load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        return this.createClassLoaderConfiguration(artifactFile, attributes, artifactType);
    }

    protected final ClassLoaderConfiguration createClassLoaderConfiguration(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        ClassLoaderModel bundleDescriptorMetadata = this.getBundleDescriptorClassLoaderModelMetadata(attributes);
        if (bundleDescriptorMetadata != null) {
            return this.createHeavyPackageClassLoaderConfiguration(artifactFile, attributes, Optional.of(this.getDeployableArtifactRepositoryFolder(artifactFile)), bundleDescriptorMetadata);
        }
        if (this.isHeavyPackage(artifactFile, attributes)) {
            return this.createHeavyPackageClassLoaderConfiguration(artifactFile, this.getClassLoaderModelDescriptor(artifactFile), attributes);
        }
        return this.createLightPackageClassLoaderConfiguration(artifactFile, attributes, artifactType, this.mavenClient.orElseThrow(() -> new UnsupportedOperationException("A MavenClient must be provided in order to handle lightweight packages.")));
    }

    private ClassLoaderModel getBundleDescriptorClassLoaderModelMetadata(Map<String, Object> attributes) {
        BundleDescriptor bundleDescriptor = (BundleDescriptor)attributes.get(BundleDescriptor.class.getName());
        if (bundleDescriptor == null) {
            return null;
        }
        return (ClassLoaderModel)bundleDescriptor.getMetadata().get(ClassLoaderModel.class.getName());
    }

    private ClassLoaderConfiguration createHeavyPackageClassLoaderConfiguration(File artifactFile, File classLoaderModelDescriptor, Map<String, Object> attributes) {
        return this.createHeavyPackageClassLoaderConfiguration(artifactFile, classLoaderModelDescriptor, attributes, Optional.of(this.getDeployableArtifactRepositoryFolder(artifactFile)));
    }

    protected ClassLoaderConfiguration createHeavyPackageClassLoaderConfiguration(File artifactFile, File classLoaderModelDescriptor, Map<String, Object> attributes, Optional<File> deployableArtifactRepositoryFolder) {
        return this.createHeavyPackageClassLoaderConfiguration(artifactFile, attributes, deployableArtifactRepositoryFolder, this.getPackagerClassLoaderModel(classLoaderModelDescriptor));
    }

    protected ClassLoaderConfiguration createHeavyPackageClassLoaderConfiguration(File artifactFile, Map<String, Object> attributes, Optional<File> deployableArtifactRepositoryFolder, ClassLoaderModel packagerClassLoaderModel) {
        List<BundleDependency> bundleDependencies;
        BundleDescriptor artifactBundleDescriptor = (BundleDescriptor)attributes.get(BundleDescriptor.class.getName());
        HeavyweightClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = this.newHeavyWeightClassLoaderConfigurationBuilder(artifactFile, artifactBundleDescriptor, packagerClassLoaderModel, attributes);
        HashSet<String> exportedPackages = new HashSet<String>(this.getAttribute(attributes, "exportedPackages"));
        HashSet<String> exportedResources = new HashSet<String>(this.getAttribute(attributes, "exportedResources"));
        classLoaderConfigurationBuilder.exportingPackages(exportedPackages).exportingResources(exportedResources).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(attributes, "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(attributes, "privilegedArtifactIds")));
        if (deployableArtifactRepositoryFolder.isPresent()) {
            List<BundleDependency> patchBundleDependencies = this.getPatchedBundledDependencies(artifactFile, deployableArtifactRepositoryFolder.get());
            bundleDependencies = packagerClassLoaderModel.getDependencies().stream().map(artifact -> {
                Optional<BundleDependency> patchedBundledDependency = patchBundleDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bundleDependency.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId())).findAny();
                return patchedBundledDependency.orElse(this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver((File)deployableArtifactRepositoryFolder.get())).apply((Artifact)artifact));
            }).collect(Collectors.toList());
        } else {
            bundleDependencies = packagerClassLoaderModel.getDependencies().stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(uri -> uri).apply((Artifact)artifact)).collect(Collectors.toList());
        }
        List<URL> patches = this.getArtifactPatches(packagerClassLoaderModel);
        List<URL> dependenciesArtifactsUrls = this.loadUrls(artifactFile, classLoaderConfigurationBuilder, bundleDependencies, patches);
        ArtifactAttributes artifactAttributes = new Semver(packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan(CLASS_LOADER_MODEL_VERSION_120) ? this.discoverLocalPackages(dependenciesArtifactsUrls) : this.collectLocalPackages(packagerClassLoaderModel);
        if (!PluginLocalDependenciesDenylist.isDenylisted(artifactBundleDescriptor)) {
            this.populateLocalPackages(artifactAttributes, classLoaderConfigurationBuilder);
        }
        classLoaderConfigurationBuilder.dependingOn(new HashSet<BundleDependency>(bundleDependencies));
        return classLoaderConfigurationBuilder.build();
    }

    private ArtifactAttributes collectLocalPackages(ClassLoaderModel packagerClassLoaderModel) {
        ImmutableSet.Builder packagesSetBuilder = ImmutableSet.builder();
        if (packagerClassLoaderModel.getPackages() != null) {
            packagesSetBuilder.add((Object[])packagerClassLoaderModel.getPackages());
        }
        ImmutableSet.Builder resourcesSetBuilder = ImmutableSet.builder();
        if (packagerClassLoaderModel.getResources() != null) {
            resourcesSetBuilder.add((Object[])packagerClassLoaderModel.getResources());
        }
        packagerClassLoaderModel.getDependencies().stream().forEach(artifact -> {
            if (artifact.getPackages() != null) {
                packagesSetBuilder.add((Object[])artifact.getPackages());
            }
            if (artifact.getResources() != null) {
                resourcesSetBuilder.add((Object[])artifact.getResources());
            }
        });
        return new ArtifactAttributes((Set<String>)packagesSetBuilder.build(), (Set<String>)resourcesSetBuilder.build());
    }

    private List<URL> getArtifactPatches(ClassLoaderModel packagerClassLoaderModel) {
        ArrayList<URL> patches;
        block7: {
            patches = new ArrayList<URL>();
            ArtifactCoordinates thisArtifactCoordinates = packagerClassLoaderModel.getArtifactCoordinates();
            String artifactId = thisArtifactCoordinates.getGroupId() + ":" + thisArtifactCoordinates.getArtifactId() + ":" + thisArtifactCoordinates.getVersion();
            try {
                String[] jarFiles;
                File muleArtifactPatchesFolder = new File(MuleContainerUtils.getMuleHome(), MULE_ARTIFACT_PATCHES_LOCATION);
                if (!muleArtifactPatchesFolder.exists()) break block7;
                VersionUtils versionUtils = VersionUtils.discoverVersionUtils(this.getClass().getClassLoader());
                for (String jarFile : jarFiles = muleArtifactPatchesFolder.list((dir, name) -> name != null && name.endsWith(".jar"))) {
                    boolean versionContained;
                    MuleArtifactPatchingModel muleArtifactPatchingModel = MuleArtifactPatchingModel.loadModel(new File(muleArtifactPatchesFolder, jarFile));
                    ArtifactCoordinates patchedArtifactCoordinates = muleArtifactPatchingModel.getArtifactCoordinates();
                    if (!patchedArtifactCoordinates.getGroupId().equals(thisArtifactCoordinates.getGroupId()) || !patchedArtifactCoordinates.getArtifactId().equals(thisArtifactCoordinates.getArtifactId()) || !patchedArtifactCoordinates.getClassifier().equals(thisArtifactCoordinates.getClassifier())) continue;
                    try {
                        versionContained = versionUtils.containsVersion(thisArtifactCoordinates.getVersion(), muleArtifactPatchingModel.getAffectedVersions());
                    }
                    catch (IllegalArgumentException e) {
                        this.LOGGER.warn(e.getMessage() + ", patches against this artifact will not be applied");
                        return Collections.emptyList();
                    }
                    if (!versionContained) continue;
                    try {
                        URL mulePluginPatchUrl = new File(MuleContainerUtils.getMuleHome(), Paths.get(MULE_ARTIFACT_PATCHES_LOCATION, jarFile).toString()).toURL();
                        patches.add(mulePluginPatchUrl);
                        this.LOGGER.info(String.format("Patching artifact %s with patch file %s", artifactId, jarFile));
                    }
                    catch (MalformedURLException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an error processing the patches in %s file for artifact %s", MULE_ARTIFACT_PATCHES_LOCATION, artifactId)), (Throwable)e);
            }
        }
        return patches;
    }

    protected abstract ClassLoaderModel getPackagerClassLoaderModel(File var1);

    private List<BundleDependency> getPatchedBundledDependencies(File artifactFile, File deployableArtifactRepositoryFolder) {
        ArrayList<BundleDependency> patchBundleDependencies = new ArrayList<BundleDependency>();
        File classLoaderModelPatchDescriptor = this.getClassLoaderModelPatchDescriptor(artifactFile);
        if (classLoaderModelPatchDescriptor.exists()) {
            ClassLoaderModel packagerClassLoaderModelPatch = ClassLoaderModelJsonSerializer.deserialize(classLoaderModelPatchDescriptor);
            patchBundleDependencies.addAll(packagerClassLoaderModelPatch.getDependencies().stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver(deployableArtifactRepositoryFolder)).apply((Artifact)artifact)).collect(Collectors.toList()));
        }
        return patchBundleDependencies;
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver(File deployableArtifactRepositoryFolder) {
        return uri -> new File(deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }

    private File getDeployableArtifactRepositoryFolder(File artifactFile) {
        if (artifactFile.isDirectory()) {
            return artifactFile;
        }
        return this.findRepositoryFolder(artifactFile).getParentFile();
    }

    private File findRepositoryFolder(File artifactFile) {
        while (!MuleFoldersUtil.getMuleHomeFolder().equals(artifactFile) && !"repository".equals(artifactFile.getName())) {
            artifactFile = artifactFile.getParentFile();
        }
        if (!"repository".equals(artifactFile.getName()) || !artifactFile.isDirectory()) {
            throw new IllegalStateException("Unable to find repository folder for artifact " + artifactFile.getAbsolutePath());
        }
        return artifactFile;
    }

    private Function<Artifact, BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).build();
        };
    }

    protected boolean isHeavyPackage(File artifactFile, Map<String, Object> attributes) {
        return this.getClassLoaderModelDescriptor(artifactFile).exists();
    }

    protected File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile, CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
    }

    protected File getClassLoaderModelPatchDescriptor(File artifactFile) {
        return new File(artifactFile, CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BundleDependency> resolveArtifactDependencies(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType, MavenClient mavenClient) {
        Optional<File> mavenRepository = this.getLocalMavenRepo(artifactFile, mavenClient);
        boolean includeProvidedDependencies = this.includeProvidedDependencies(artifactType);
        Optional<MavenReactorResolver> mavenReactorResolver = Optional.ofNullable((MavenReactorResolver)attributes.get(CLASSLOADER_MODEL_MAVEN_REACTOR_RESOLVER));
        Optional<File> temporaryDirectory = Optional.of(Files.createTempDir());
        try {
            List<org.mule.maven.pom.parser.api.model.BundleDependency> dependencies = mavenClient.resolveArtifactDependencies(artifactFile, this.includeTestDependencies(attributes), includeProvidedDependencies, mavenRepository, mavenReactorResolver, temporaryDirectory);
            DependencyConverter dependencyConverter = new DependencyConverter();
            List<BundleDependency> list = dependencies.stream().map(dependencyConverter::convert).collect(Collectors.toList());
            return list;
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryDirectory.get());
        }
    }

    protected final Optional<File> getLocalMavenRepo(File artifactFile, MavenClient mavenClient) {
        Optional<File> mavenRepository = Optional.ofNullable(mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation());
        if (!mavenRepository.isPresent()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Missing Maven local repository configuration while trying to resolve class loader configuration for lightweight artifact: %s", artifactFile.getName())));
        }
        return mavenRepository;
    }

    protected ClassLoaderConfiguration createLightPackageClassLoaderConfiguration(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType, MavenClient mavenClient) {
        List<BundleDependency> resolvedDependencies = this.resolveArtifactDependencies(artifactFile, attributes, artifactType, mavenClient);
        List<BundleDependency> nonProvidedDependencies = resolvedDependencies.stream().filter(dep -> !BundleScope.PROVIDED.equals((Object)dep.getScope())).collect(Collectors.toList());
        BundleDescriptor artifactBundleDescriptor = (BundleDescriptor)attributes.get(BundleDescriptor.class.getName());
        LightweightClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = this.newLightweightClassLoaderConfigurationBuilder(artifactFile, artifactBundleDescriptor, mavenClient, attributes, nonProvidedDependencies);
        HashSet<String> exportedPackages = new HashSet<String>(this.getAttribute(attributes, "exportedPackages"));
        HashSet<String> exportedResources = new HashSet<String>(this.getAttribute(attributes, "exportedResources"));
        classLoaderConfigurationBuilder.exportingPackages(exportedPackages).exportingResources(exportedResources).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(attributes, "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(attributes, "privilegedArtifactIds"))).includeTestDependencies(Boolean.valueOf(this.getSimpleAttribute(attributes, "includeTestDependencies", "false")));
        List<URL> dependenciesArtifactsUrls = this.loadUrls(artifactFile, classLoaderConfigurationBuilder, nonProvidedDependencies, Collections.emptyList());
        if (!PluginLocalDependenciesDenylist.isDenylisted(artifactBundleDescriptor)) {
            this.populateLocalPackages(this.discoverLocalPackages(dependenciesArtifactsUrls), classLoaderConfigurationBuilder);
        }
        classLoaderConfigurationBuilder.dependingOn(new HashSet<BundleDependency>(resolvedDependencies));
        return classLoaderConfigurationBuilder.build();
    }

    protected abstract LightweightClassLoaderConfigurationBuilder newLightweightClassLoaderConfigurationBuilder(File var1, BundleDescriptor var2, MavenClient var3, Map<String, Object> var4, List<BundleDependency> var5);

    protected abstract HeavyweightClassLoaderConfigurationBuilder newHeavyWeightClassLoaderConfigurationBuilder(File var1, BundleDescriptor var2, ClassLoaderModel var3, Map<String, Object> var4);

    private ArtifactAttributes discoverLocalPackages(List<URL> dependenciesArtifactsUrls) {
        HashSet<String> packages = new HashSet<String>();
        HashSet<String> resources = new HashSet<String>();
        for (URL dependencyArtifactUrl : dependenciesArtifactsUrls) {
            URI dependencyArtifactUri;
            try {
                dependencyArtifactUri = dependencyArtifactUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException(e);
            }
            try {
                JarInfo exploredJar = this.jarExplorerFactory.get().explore(dependencyArtifactUri);
                packages.addAll(exploredJar.getPackages());
                resources.addAll(exploredJar.getResources());
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.warn("File for dependency artifact not found: '{}'. Skipped localPackages scanning for that artifact.", (Object)dependencyArtifactUri);
            }
        }
        return new ArtifactAttributes(packages, resources);
    }

    protected void populateLocalPackages(ArtifactAttributes artifactAttributes, ArtifactClassLoaderConfigurationBuilder classLoaderConfigurationBuilder) {
        classLoaderConfigurationBuilder.withLocalPackages(new HashSet<String>(artifactAttributes.getPackages()));
        classLoaderConfigurationBuilder.withLocalResources(new HashSet<String>(artifactAttributes.getResources()));
    }

    protected abstract boolean includeProvidedDependencies(ArtifactType var1);

    private List<URL> loadUrls(File artifactFile, ArtifactClassLoaderConfigurationBuilder classLoaderConfigurationBuilder, List<BundleDependency> dependencies, List<URL> patches) {
        for (URL patchUrl : patches) {
            classLoaderConfigurationBuilder.containing(patchUrl);
        }
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        URL artifactFileUrl = this.getUrl(artifactFile, artifactFile);
        classLoaderConfigurationBuilder.containing(artifactFileUrl);
        dependenciesArtifactsUrls.add(artifactFileUrl);
        dependenciesArtifactsUrls.addAll(this.addArtifactSpecificClassloaderConfiguration(classLoaderConfigurationBuilder));
        dependenciesArtifactsUrls.addAll(this.addDependenciesToClasspathUrls(artifactFile, classLoaderConfigurationBuilder, dependencies));
        return dependenciesArtifactsUrls;
    }

    private URL getUrl(File artifactFile, File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", artifactFile.getAbsolutePath(), file.getAbsolutePath()), e);
        }
    }

    private List<URL> addDependenciesToClasspathUrls(File artifactFile, ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder, List<BundleDependency> dependencies) {
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        dependencies.stream().filter(dependency -> !"mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))).filter(dependency -> dependency.getBundleUri() != null).filter(dependency -> !this.validateMuleRuntimeSharedLibrary(dependency.getDescriptor().getGroupId(), dependency.getDescriptor().getArtifactId(), artifactFile.getName())).forEach(dependency -> {
            URL dependencyArtifactUrl;
            try {
                dependencyArtifactUrl = dependency.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
            classLoaderConfigurationBuilder.containing(dependencyArtifactUrl);
            dependenciesArtifactsUrls.add(dependencyArtifactUrl);
        });
        return dependenciesArtifactsUrls;
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId, String artifactFileName) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            this.LOGGER.warn("Internal plugin library '{}:{}' is a Mule Runtime dependency. It will not be used by '{}' in order to avoid classloading issues. Please consider removing it, or at least not putting it with 'compile' scope.", new Object[]{groupId, artifactId, artifactFileName});
            return true;
        }
        return false;
    }

    private List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        ArrayList attributeObject = attributes.getOrDefault(attribute, new ArrayList());
        Preconditions.checkArgument(attributeObject instanceof List, String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    private <T> T getSimpleAttribute(Map<String, Object> attributes, String attribute, T defaultValue) {
        return (T)attributes.getOrDefault(attribute, defaultValue);
    }

    protected boolean includeTestDependencies(Map<String, Object> attributes) {
        return false;
    }

    protected List<URL> addArtifactSpecificClassloaderConfiguration(ArtifactClassLoaderConfigurationBuilder classLoaderConfigurationBuilder) {
        return Collections.emptyList();
    }
}

