/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.internal.logging.LogUtil;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeployerMonitorThreadFactory;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementRemovedEvent;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDirectoryWatcher
implements Runnable {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final String CHANGE_CHECK_INTERVAL_PROPERTY = "mule.launcher.changeCheckInterval";
    public static final IOFileFilter JAR_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".jar", IOCase.INSENSITIVE), FileFileFilter.FILE);
    public static final IOFileFilter ZIP_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".zip", IOCase.INSENSITIVE), FileFileFilter.FILE);
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock deploymentLock;
    private final ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer;
    protected final ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer;
    protected final Supplier<SchedulerService> schedulerServiceSupplier;
    private final ArtifactTimestampListener<Application> applicationTimestampListener;
    private final ArtifactTimestampListener<Domain> domainTimestampListener;
    private final ObservableList<Application> applications;
    private final ObservableList<Domain> domains;
    private final DomainBundleArchiveDeployer domainBundleDeployer;
    private final File appsDir;
    private final File domainsDir;
    private ScheduledExecutorService artifactDirMonitorTimer;
    protected volatile boolean dirty;

    public DeploymentDirectoryWatcher(DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock) {
        this.domainBundleDeployer = domainBundleDeployer;
        this.appsDir = applicationArchiveDeployer.getDeploymentDirectory();
        this.domainsDir = domainArchiveDeployer.getDeploymentDirectory();
        this.deploymentLock = deploymentLock;
        this.domainArchiveDeployer = domainArchiveDeployer;
        this.applicationArchiveDeployer = applicationArchiveDeployer;
        this.applications = applications;
        this.domains = domains;
        applications.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        domains.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        this.schedulerServiceSupplier = schedulerServiceSupplier;
        this.applicationTimestampListener = new ArtifactTimestampListener<Application>(applications);
        this.domainTimestampListener = new ArtifactTimestampListener<Domain>(domains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.deploymentLock.lock();
        this.deleteAllAnchors();
        String appString = System.getProperty("mule.deploy.applications");
        try {
            if (appString == null) {
                this.run();
                this.scheduleChangeMonitor();
            } else {
                String[] explodedDomains = this.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] packagedDomains = this.listFiles(this.domainsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
                this.deployPackedDomains(packagedDomains);
                this.deployExplodedDomains(explodedDomains);
                String[] apps = appString.split(":");
                for (String app : apps = this.removeDuplicateAppNames(apps)) {
                    try {
                        File applicationFile = new File(this.appsDir, app + ".jar");
                        if (applicationFile.exists() && applicationFile.isFile()) {
                            this.applicationArchiveDeployer.deployPackagedArtifact(app + ".jar", Optional.empty());
                            continue;
                        }
                        if (!this.applicationArchiveDeployer.isUpdatedZombieArtifact(app)) continue;
                        this.applicationArchiveDeployer.deployExplodedArtifact(app, Optional.empty());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                LogUtil.log(SplashScreen.miniSplash("Mule is up and running in a fixed app set mode"));
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public void stop() {
        this.stopAppDirMonitorTimer();
        this.deploymentLock.lock();
        try {
            this.notifyStopListeners();
            this.stopArtifacts(this.applications);
            this.stopArtifacts(this.domains);
        }
        finally {
            this.deploymentLock.unlock();
        }
    }

    private void stopArtifacts(List<? extends DeployableArtifact> artifacts) {
        Collections.reverse(artifacts);
        for (DeployableArtifact deployableArtifact : artifacts) {
            try {
                deployableArtifact.stop();
                deployableArtifact.dispose();
            }
            catch (Throwable t) {
                this.logger.error("Error stopping artifact {}", (Object)deployableArtifact.getArtifactName(), (Object)t);
            }
        }
    }

    static int getChangesCheckIntervalMs() {
        try {
            String value = System.getProperty(CHANGE_CHECK_INTERVAL_PROPERTY);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    private void scheduleChangeMonitor() {
        int reloadIntervalMs = DeploymentDirectoryWatcher.getChangesCheckIntervalMs();
        this.artifactDirMonitorTimer = Executors.newSingleThreadScheduledExecutor(new ArtifactDeployerMonitorThreadFactory());
        this.artifactDirMonitorTimer.scheduleWithFixedDelay(this, reloadIntervalMs, reloadIntervalMs, TimeUnit.MILLISECONDS);
        LogUtil.log(SplashScreen.miniSplash(String.format("Mule is up and kicking (every %dms)", reloadIntervalMs)));
    }

    protected void deployPackedApps(String[] zips) {
        for (String zip : zips) {
            try {
                this.applicationArchiveDeployer.deployPackagedArtifact(zip, Optional.empty());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void deployExplodedApps(String[] apps) {
        for (String addedApp : apps) {
            try {
                this.applicationArchiveDeployer.deployExplodedArtifact(addedApp, Optional.empty());
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking for changes...");
            }
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: " + ((DebuggableReentrantLock)this.deploymentLock).getOwner());
                }
                return;
            }
            this.undeployRemovedApps();
            this.undeployRemovedDomains();
            this.deployDomainBundles();
            String[] domains = this.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] domainZips = this.listFiles(this.domainsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
            this.redeployModifiedDomains();
            this.deployPackedDomains(domainZips);
            if (domainZips.length > 0 || this.dirty) {
                domains = this.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            this.deployExplodedDomains(domains);
            this.redeployModifiedApplications();
            Object[] apps = this.listFiles(this.appsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] appZips = this.listFiles(this.appsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
            this.deployPackedApps(appZips);
            if (appZips.length > 0 || this.dirty) {
                apps = this.listFiles(this.appsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            Arrays.sort(apps);
            this.deployExplodedApps((String[])apps);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            } else {
                this.logger.error("Exception processing deployment watch dir.", (Throwable)e);
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
            this.dirty = false;
        }
    }

    private void deployDomainBundles() {
        String[] domainBundles;
        for (String domainBundle : domainBundles = this.listFiles(this.domainsDir, (FilenameFilter)ZIP_ARTIFACT_FILTER)) {
            try {
                File domainBundleFile = new File(MuleFoldersUtil.getDomainsFolder(), domainBundle);
                this.domainBundleDeployer.deployArtifact(domainBundleFile.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String[] listFiles(File directory, FilenameFilter filter) {
        String[] files = directory.list(filter);
        if (files == null) {
            throw new IllegalStateException(String.format("We got a null while listing the contents of director '%s'. Some common causes for this is a lack of permissions to the directory or that it's being deleted concurrently", directory.getName()));
        }
        return files;
    }

    public <D extends DeployableArtifactDescriptor, T extends Artifact<D>> T findArtifact(String artifactName, ObservableList<T> artifacts) {
        return (T)((Artifact)artifacts.stream().filter(artifact -> artifact.getArtifactName().equals(artifactName)).findFirst().orElse(null));
    }

    private void undeployRemovedDomains() {
        this.undeployRemovedArtifacts(this.domainsDir, this.domains, this.domainArchiveDeployer);
    }

    private void undeployRemovedApps() {
        this.undeployRemovedArtifacts(this.appsDir, this.applications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor> void undeployRemovedArtifacts(File artifactDir, ObservableList<? extends Artifact<D>> artifacts, ArchiveDeployer<D, ? extends Artifact<D>> archiveDeployer) {
        String[] currentAnchors = this.listFiles(artifactDir, (FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX));
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Current anchors:%n", new Object[0]));
            for (String currentAnchor : currentAnchors) {
                sb.append(String.format("  %s%n", currentAnchor));
            }
            this.logger.debug(sb.toString());
        }
        Set currentAnchorsSet = Arrays.stream(currentAnchors).collect(Collectors.toSet());
        Collection deletedAnchors = Arrays.stream(this.findExpectedAnchorFiles(artifacts)).filter(a -> !currentAnchorsSet.contains(a)).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Deleted anchors:%n", new Object[0]));
            for (String deletedAnchor : deletedAnchors) {
                sb.append(String.format("  %s%n", deletedAnchor));
            }
            this.logger.debug(sb.toString());
        }
        for (String deletedAnchor : deletedAnchors) {
            String artifactName = StringUtils.removeEnd((String)deletedAnchor, (String)ARTIFACT_ANCHOR_SUFFIX);
            try {
                if (this.findArtifact(artifactName, artifacts) != null) {
                    archiveDeployer.undeployArtifact(artifactName);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.format("Artifact [%s] has already been undeployed via API", artifactName));
            }
            catch (Throwable t) {
                this.logger.error("Failed to undeployArtifact artifact: " + artifactName, t);
            }
        }
    }

    private <D extends DeployableArtifactDescriptor> String[] findExpectedAnchorFiles(ObservableList<? extends Artifact<D>> artifacts) {
        String[] anchors = new String[artifacts.size()];
        int i = 0;
        for (Artifact<D> artifact : artifacts) {
            anchors[i++] = artifact.getArtifactName() + ARTIFACT_ANCHOR_SUFFIX;
        }
        return anchors;
    }

    private void deployExplodedDomains(String[] domains) {
        for (String addedDomain : domains) {
            try {
                if (!this.domainArchiveDeployer.isUpdatedZombieArtifact(addedDomain)) continue;
                this.domainArchiveDeployer.deployExplodedArtifact(addedDomain, Optional.empty());
            }
            catch (DeploymentException e) {
                this.logger.error("Error deploying domain '{}'", (Object)addedDomain, (Object)e);
            }
        }
    }

    private void deployPackedDomains(String[] zips) {
        for (String zip : zips) {
            try {
                this.domainArchiveDeployer.deployPackagedArtifact(zip, Optional.empty());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteAllAnchors() {
        this.deleteAnchorsFromDirectory(this.domainsDir);
        this.deleteAnchorsFromDirectory(this.appsDir);
    }

    private void deleteAnchorsFromDirectory(File directory) {
        String[] anchors;
        for (String anchor : anchors = this.listFiles(directory, (FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX))) {
            new File(directory, anchor).delete();
        }
    }

    private String[] removeDuplicateAppNames(String[] apps) {
        LinkedList<String> appNames = new LinkedList<String>();
        for (String appName : apps) {
            if (appNames.contains(appName)) continue;
            appNames.add(appName);
        }
        return appNames.toArray(new String[appNames.size()]);
    }

    private void redeployModifiedDomains() {
        Collection<String> redeployableDomains = this.getArtifactsToRedeploy(this.domains, this.domainTimestampListener);
        this.redeployModifiedArtifacts(redeployableDomains, this.domainArchiveDeployer);
    }

    private void redeployModifiedApplications() {
        Collection<String> redeployableApplications = this.getArtifactsToRedeploy(this.applications, this.applicationTimestampListener);
        this.redeployModifiedArtifacts(redeployableApplications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor, T extends DeployableArtifact<D>> Collection<String> getArtifactsToRedeploy(Collection<T> collection, ArtifactTimestampListener<T> artifactTimestampListener) {
        return collection.stream().filter(artifact -> ((DeployableArtifactDescriptor)artifact.getDescriptor()).isRedeploymentEnabled()).filter(artifactTimestampListener::isArtifactResourceUpdated).map(Artifact::getArtifactName).collect(Collectors.toList());
    }

    private <D extends DeployableArtifactDescriptor, T extends Artifact<D>> void redeployModifiedArtifacts(Collection<String> artifactNames, ArchiveDeployer<D, T> artifactArchiveDeployer) {
        for (String artifactName : artifactNames) {
            try {
                artifactArchiveDeployer.redeploy(artifactName, Optional.empty());
            }
            catch (DeploymentException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error redeploying artifact {}", (Object)artifactName, (Object)e);
            }
        }
    }

    private void stopAppDirMonitorTimer() {
        if (this.artifactDirMonitorTimer != null) {
            this.artifactDirMonitorTimer.shutdown();
            try {
                this.artifactDirMonitorTimer.awaitTermination(DeploymentDirectoryWatcher.getChangesCheckIntervalMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void notifyStopListeners() {
        for (Application application : this.applications) {
            this.applicationArchiveDeployer.doNotPersistArtifactStop(application);
        }
        for (Domain domain : this.domains) {
            this.domainArchiveDeployer.doNotPersistArtifactStop(domain);
        }
    }

    private static class ArtifactResourcesTimestamp<T extends Artifact> {
        private final Map<String, Long> timestampsPerResource = new HashMap<String, Long>();

        public ArtifactResourcesTimestamp(Artifact artifact) {
            for (File configResourceFile : artifact.getResourceFiles()) {
                this.timestampsPerResource.put(configResourceFile.getAbsolutePath(), configResourceFile.lastModified());
            }
            File descriptorFile = new File(((DeployableArtifactDescriptor)artifact.getDescriptor()).getArtifactLocation(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION);
            if (descriptorFile.exists()) {
                this.timestampsPerResource.put(descriptorFile.getAbsolutePath(), descriptorFile.lastModified());
            }
        }

        public boolean resourcesHaveSameTimestamp() {
            return this.timestampsPerResource.entrySet().stream().noneMatch(entry -> {
                long currentTimestamp;
                File trackedFile = new File((String)entry.getKey());
                long originalTimestamp = (Long)entry.getValue();
                if (originalTimestamp != (currentTimestamp = trackedFile.lastModified())) {
                    this.timestampsPerResource.put((String)entry.getKey(), currentTimestamp);
                    return true;
                }
                return false;
            });
        }
    }

    private static class ArtifactTimestampListener<T extends Artifact>
    implements PropertyChangeListener {
        private final Map<String, ArtifactResourcesTimestamp<T>> artifactConfigResourcesTimestaps = new HashMap<String, ArtifactResourcesTimestamp<T>>();

        public ArtifactTimestampListener(ObservableList<T> artifacts) {
            artifacts.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof ElementAddedEvent) {
                Artifact artifactAdded = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.put(artifactAdded.getArtifactName(), new ArtifactResourcesTimestamp(artifactAdded));
            } else if (event instanceof ElementRemovedEvent) {
                Artifact artifactRemoved = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.remove(artifactRemoved.getArtifactName());
            }
        }

        public boolean isArtifactResourceUpdated(T artifact) {
            ArtifactResourcesTimestamp<T> applicationResourcesTimestamp = this.artifactConfigResourcesTimestaps.get(artifact.getArtifactName());
            return !applicationResourcesTimestamp.resourcesHaveSameTimestamp();
        }
    }
}

