/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.operation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.client.EventedExtensionsClientDecorator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StreamingHelperArgumentResolver;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.exception.error.SoapExceptionEnricher;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapRequestBuilder;
import org.mule.runtime.soap.api.message.SoapResponse;

public final class SoapOperationExecutor
implements CompletableComponentExecutor<OperationModel>,
Initialisable {
    @Inject
    private MuleExpressionLanguage expressionExecutor;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtensionsClient extensionsClient;
    private final ConnectionArgumentResolver connectionResolver = new ConnectionArgumentResolver();
    private final StreamingHelperArgumentResolver streamingHelperArgumentResolver = new StreamingHelperArgumentResolver();
    private final SoapExceptionEnricher soapExceptionEnricher = new SoapExceptionEnricher();
    private CompiledExpression headersExpression;

    @Override
    public void execute(ExecutionContext<OperationModel> context, CompletableComponentExecutor.ExecutorCallback callback) {
        try {
            String serviceId = (String)context.getParameter("service");
            ForwardingSoapClient connection = (ForwardingSoapClient)this.connectionResolver.resolve(context);
            Map<String, String> customHeaders = connection.getCustomHeaders(serviceId, this.getOperation(context));
            SoapRequest request = this.getRequest(context, customHeaders);
            SoapClient soapClient = connection.getSoapClient(serviceId);
            SoapResponse response = connection.getExtensionsClientDispatcher(() -> new EventedExtensionsClientDecorator(this.extensionsClient, ((ExecutionContextAdapter)context).getEvent())).map(d -> soapClient.consume(request, (MessageDispatcher)d)).orElseGet(() -> soapClient.consume(request));
            callback.complete(response.getAsResult(this.streamingHelperArgumentResolver.resolve(context)));
        }
        catch (MessageTransformerException | TransformerException e) {
            callback.error(e);
        }
        catch (Exception e) {
            callback.error(this.soapExceptionEnricher.enrich(e));
        }
        catch (Throwable t) {
            callback.error(Exceptions.wrapFatal(t));
        }
    }

    @Override
    public void initialise() {
        this.headersExpression = this.expressionExecutor.compile("%dw 2.0 \noutput application/java \n---\npayload.headers mapObject (value, key) -> {\n    '$key' : write((key): value, \"application/xml\")\n}", BindingContext.builder().addBinding("payload", new TypedValue<String>("", DataType.XML_STRING)).build());
    }

    private SoapRequest getRequest(ExecutionContext<OperationModel> context, Map<String, String> fixedHeaders) throws MessageTransformerException, TransformerException {
        SoapRequestBuilder builder = SoapRequest.builder().operation(this.getOperation(context));
        builder.soapHeaders(fixedHeaders);
        Optional optionalMessageGroup = this.getParam(context, "Message");
        if (optionalMessageGroup.isPresent()) {
            Map attachments;
            InputStream headers;
            Map message = (Map)optionalMessageGroup.get();
            InputStream body2 = (InputStream)message.get("body");
            if (body2 != null) {
                builder.content(body2);
            }
            if ((headers = (InputStream)message.get("headers")) != null) {
                builder.soapHeaders((Map)this.evaluateHeaders(headers));
            }
            if ((attachments = (Map)message.get("attachments")) != null) {
                this.toSoapAttachments(attachments).forEach(builder::attachment);
            }
        }
        this.getParam(context, "transportHeaders").ifPresent(th -> builder.transportHeaders((Map)th));
        return builder.build();
    }

    private String getOperation(ExecutionContext<OperationModel> context) {
        return (String)this.getParam(context, "operation").orElseThrow(() -> new IllegalStateException("Execution Context does not have the required operation parameter"));
    }

    private <T> Optional<T> getParam(ExecutionContext<OperationModel> context, String param) {
        return context.hasParameter(param) ? Optional.ofNullable(context.getParameter(param)) : Optional.empty();
    }

    private Object evaluateHeaders(InputStream headers) {
        String hs = IOUtils.toString(headers);
        BindingContext context = BindingContext.builder().addBinding("payload", new TypedValue<String>(hs, DataType.XML_STRING)).build();
        try (ExpressionLanguageSession session = this.expressionExecutor.openSession(context);){
            Object obj = session.evaluate(this.headersExpression).getValue();
            return obj;
        }
    }

    private Map<String, SoapAttachment> toSoapAttachments(Map<String, TypedValue<?>> attachments) throws MessageTransformerException, TransformerException {
        HashMap<String, SoapAttachment> soapAttachmentMap = new HashMap<String, SoapAttachment>();
        for (Map.Entry<String, TypedValue<?>> attachment : attachments.entrySet()) {
            SoapAttachment soapAttachment = new SoapAttachment(this.toInputStream(attachment.getValue()), attachment.getValue().getDataType().getMediaType());
            soapAttachmentMap.put(attachment.getKey(), soapAttachment);
        }
        return soapAttachmentMap;
    }

    private InputStream toInputStream(TypedValue typedValue) throws MessageTransformerException, TransformerException {
        Object value = typedValue.getValue();
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        return (InputStream)this.transformationService.transform(value, DataType.fromObject(value), DataType.INPUT_STREAM);
    }
}

