/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import javax.inject.Inject;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporter;
import org.mule.runtime.tracer.exporter.impl.capturer.CapturingSpanExporterWrapper;
import org.mule.runtime.tracer.exporter.impl.optel.config.OpenTelemetryAutoConfigurableSpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.optel.resources.OpenTelemetryResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetrySpanExporterFactory
implements SpanExporterFactory,
Disposable,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetrySpanExporterFactory.class);
    private SpanExporterConfiguration configuration;
    private SpanExporterConfiguration privilegedConfiguration = new OpenTelemetryAutoConfigurableSpanExporterConfiguration(key -> null);
    private static final CapturingSpanExporterWrapper SNIFFED_EXPORTER = new CapturingSpanExporterWrapper(OpenTelemetryResources.NoOpSpanExporter.getInstance());
    private FeatureFlaggingService featureFlaggingService;
    private MuleContext muleContext;
    private SpanProcessor spanProcessor;
    private Resource resource;
    private String artifactId;
    private String artifactType;
    private boolean addMuleAncestorSpanId;

    public OpenTelemetrySpanExporterFactory() {
    }

    protected OpenTelemetrySpanExporterFactory(SpanExporterConfiguration privilegedConfiguration) {
        this.privilegedConfiguration = privilegedConfiguration;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setFeatureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }

    @Override
    public org.mule.runtime.tracer.api.span.exporter.SpanExporter getSpanExporter(InternalSpan internalSpan, InitialSpanInfo initialSpanInfo) {
        return new OpenTelemetrySpanExporter(internalSpan, initialSpanInfo, this.artifactId, this.artifactType, this.spanProcessor, this.addMuleAncestorSpanId, this.resource);
    }

    protected SpanProcessor resolveOpenTelemetrySpanProcessor() {
        if (this.isExportEnabled()) {
            return this.resolveSpanProcessor();
        }
        return SimpleSpanProcessor.create((SpanExporter)OpenTelemetryResources.NoOpSpanExporter.getInstance());
    }

    private SpanProcessor resolveSpanProcessor() {
        if (Boolean.getBoolean("mule.openTelemetry.tracer.exporter.use.sniffer")) {
            return SimpleSpanProcessor.create((SpanExporter)SNIFFED_EXPORTER);
        }
        LOGGER.info("Mule Open Telemetry Tracer Exporter is enabled.");
        return OpenTelemetryResources.resolveOpenTelemetrySpanProcessor(this.configuration, this.privilegedConfiguration, this.resolveOpenTelemetrySpanExporter());
    }

    private boolean isExportEnabled() {
        return Boolean.parseBoolean(this.configuration.getStringValue("mule.openTelemetry.tracer.exporter.enabled"));
    }

    protected SpanExporter resolveOpenTelemetrySpanExporter() {
        return OpenTelemetryResources.resolveOpenTelemetrySpanExporter(this.configuration);
    }

    @Override
    public SpanSnifferManager getSpanSnifferManager() {
        return new OpenTelemetrySpanSnifferManager();
    }

    @Inject
    protected void setConfiguration(SpanExporterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.artifactId = this.muleContext.getConfiguration().getId();
        this.artifactType = this.muleContext.getArtifactType().getAsString();
        this.resource = OpenTelemetryResources.getResource(this.artifactId);
        this.spanProcessor = this.resolveOpenTelemetrySpanProcessor();
        this.addMuleAncestorSpanId = this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ADD_MULE_SPECIFIC_TRACING_INFORMATION_IN_TRACE_STATE);
        this.configuration.doOnConfigurationChanged(this::doOnConfigurationChanged);
    }

    private void doOnConfigurationChanged() {
        SpanProcessor previousSpanProcessor = this.spanProcessor;
        this.spanProcessor = this.resolveOpenTelemetrySpanProcessor();
        OpenTelemetrySpanExporterFactory.silentlyShutdown(previousSpanProcessor);
    }

    private static void silentlyShutdown(SpanProcessor previousSpanProcessor) {
        try {
            previousSpanProcessor.shutdown();
        }
        catch (Throwable e) {
            LOGGER.warn("Error in disposing span processor", e);
        }
    }

    @Override
    public void dispose() {
        OpenTelemetrySpanExporterFactory.silentlyShutdown(this.spanProcessor);
    }

    private static class OpenTelemetrySpanSnifferManager
    implements SpanSnifferManager {
        private OpenTelemetrySpanSnifferManager() {
        }

        @Override
        public ExportedSpanSniffer getExportedSpanSniffer() {
            return SNIFFED_EXPORTER.getExportedSpanSniffer();
        }
    }
}

