/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.tracer.common.watcher.TracingConfigurationFileWatcher;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTracingLevelConfiguration
implements TracingLevelConfiguration,
Disposable {
    private final String CONFIGURATION_FILE_PATH = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName());
    private final MuleContext muleContext;
    private SpanExporterConfiguration spanExporterConfiguration;
    private static final String CONFIGURATION_FILE_NAME = "tracing-level.conf";
    private static final String LEVEL_PROPERTY_NAME = "mule.openTelemetry.tracer.level";
    private static final String OVERRIDES_PROPERTY_NAME = "mule.openTelemetry.tracer.levelOverrides";
    private static final TracingLevel DEFAULT_LEVEL = TracingLevel.MONITORING;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTracingLevelConfiguration.class);
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final HashMap<String, TracingLevel> tracingLevelOverrides = new HashMap();
    private boolean tracingConfigurationFileWatcherInitialised;
    private TracingLevel tracingLevel = null;
    private JsonNode configuration;
    private List<Runnable> onConfigurationChangeRunnables = Collections.synchronizedList(new ArrayList());
    private URL configurationUrl;
    private TracingConfigurationFileWatcher tracingConfigurationFileWatcher;
    private ConfigurationPropertiesResolver propertyResolver;

    public FileTracingLevelConfiguration(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setSpanExporterConfiguration(SpanExporterConfiguration spanExporterConfiguration) {
        this.spanExporterConfiguration = spanExporterConfiguration;
    }

    private Runnable getOnConfigurationChanged() {
        return () -> this.onConfigurationChangeRunnables.forEach(Runnable::run);
    }

    private void setTracingLevels() {
        this.configuration = this.getTracingLevelConfiguration();
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());
        this.setTracingLevel();
        this.setTracingLevelOverrides();
    }

    private void setTracingLevel() {
        this.tracingLevel = DEFAULT_LEVEL;
        String configuredTracingLevel = this.readStringFromConfig(LEVEL_PROPERTY_NAME);
        if (configuredTracingLevel != null) {
            try {
                configuredTracingLevel = this.propertyResolver.apply(configuredTracingLevel);
                this.tracingLevel = TracingLevel.valueOf(configuredTracingLevel.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(String.format("Wrong tracing level found in configuration file: %s. The tracing level will be set to the default level: %s", new Object[]{configuredTracingLevel, DEFAULT_LEVEL}));
            }
        }
    }

    private void setTracingLevelOverrides() {
        this.readStringListFromConfig(OVERRIDES_PROPERTY_NAME).forEach(override -> {
            String[] levelOverride = override.split("=");
            if (levelOverride.length != 2) {
                LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
            } else {
                try {
                    this.tracingLevelOverrides.put(levelOverride[0], TracingLevel.valueOf(levelOverride[1].toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
                }
            }
        });
    }

    @Override
    public TracingLevel getTracingLevel() {
        if (this.tracingLevel == null) {
            this.initialise();
        }
        return this.tracingLevel;
    }

    private void initialise() {
        this.setTracingLevels();
        this.onConfigurationChangeRunnables.add(() -> this.setTracingLevels());
        if (this.configuration != null && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new TracingConfigurationFileWatcher(this.configurationUrl.getFile(), this.getOnConfigurationChanged());
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    @Override
    public TracingLevel getTracingLevelOverride(String location) {
        TracingLevel tracingLevelOverride;
        if (this.tracingLevel == null) {
            this.initialise();
        }
        if ((tracingLevelOverride = this.getTracingLevelOverrideFrom(location)) != null) {
            return tracingLevelOverride;
        }
        return this.tracingLevel;
    }

    @Override
    public void onConfigurationChange(Consumer<TracingLevelConfiguration> onConfigurationChangeConsumer) {
        this.onConfigurationChangeRunnables.add(() -> onConfigurationChangeConsumer.accept(this));
    }

    @Override
    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    private TracingLevel getTracingLevelOverrideFrom(String location) {
        return this.tracingLevelOverrides.get(location);
    }

    private JsonNode getTracingLevelConfiguration() {
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        try {
            InputStream is = resourceProvider.getResourceAsStream(this.CONFIGURATION_FILE_PATH);
            this.configurationUrl = ClassUtils.getResourceOrFail(this.CONFIGURATION_FILE_PATH, this.getExecutionClassLoader(this.muleContext), true);
            return FileTracingLevelConfiguration.loadConfiguration(is);
        }
        catch (IOException | MuleRuntimeException e) {
            if (Boolean.parseBoolean(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.enabled", "false"))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Non existent or non parseable tracing level config file found. The tracing level will be set to the default: %s", new Object[]{DEFAULT_LEVEL}), (Throwable)e);
                } else {
                    LOGGER.info(String.format("Non existent or non parseable tracing level config file found. The tracing level will be set to the default: %s. Enable DEBUG log level to see the exception", new Object[]{DEFAULT_LEVEL}));
                }
            }
            return null;
        }
    }

    private static JsonNode loadConfiguration(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull("input stream");
            throw new IOException(error.toString());
        }
        try {
            JsonNode jsonNode = configFileMapper.readTree(is);
            return jsonNode;
        }
        finally {
            is.close();
        }
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    protected String getPropertiesFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    protected String getConfFolder() {
        return System.getProperty("mule.tracing.level.configuration.path", MuleFoldersUtil.getConfFolder().getAbsolutePath());
    }

    private String readStringFromConfig(String key) {
        if (this.configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = this.configuration;
            for (int i = 0; i < path.length && configurationValue.get(path[i]) != null; ++i) {
                configurationValue = configurationValue.get(path[i]);
            }
            return configurationValue != null && !configurationValue.asText().isEmpty() ? configurationValue.asText() : null;
        }
        return null;
    }

    private List<String> readStringListFromConfig(String key) {
        ArrayList<String> configuredValues = new ArrayList<String>();
        if (this.configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = this.configuration;
            for (int i = 0; i < path.length && configurationValue != null; configurationValue = configurationValue.get(path[i]), ++i) {
            }
            if (configurationValue != null) {
                configurationValue.elements().forEachRemaining(jsonNode -> {
                    if (jsonNode.isTextual()) {
                        configuredValues.add(jsonNode.textValue());
                    }
                });
            }
        }
        return configuredValues;
    }
}

