/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.math;

import org.mule.weave.v2.core.exception.InvalidNumberExpressionException;
import org.mule.weave.v2.model.values.coercion.NumberUtils;
import org.mule.weave.v2.model.values.coercion.NumberUtils$;
import org.mule.weave.v2.model.values.math.BigDecimalNumber;
import org.mule.weave.v2.model.values.math.BigIntNumber;
import org.mule.weave.v2.model.values.math.LongNumber;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Double$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;

public final class Number$ {
    public static Number$ MODULE$;
    private final BigDecimal minDouble;
    private final BigDecimal maxDouble;

    static {
        new Number$();
    }

    public BigDecimal minDouble() {
        return this.minDouble;
    }

    public BigDecimal maxDouble() {
        return this.maxDouble;
    }

    public Number apply(String n) {
        return this.apply(UnknownLocation$.MODULE$, n);
    }

    public Number apply(Location location, String n) {
        Number number;
        NumberUtils.ParsingResult result = NumberUtils$.MODULE$.parseLong(n);
        if (result.resultType() == NumberUtils$.MODULE$.OK()) {
            number = new LongNumber(((Number)result.number().get()).toLong());
        } else {
            try {
                number = new BigIntNumber(package$.MODULE$.BigInt().apply(n));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    number = new BigDecimalNumber(package$.MODULE$.BigDecimal().apply(n));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new InvalidNumberExpressionException(location, n, numberFormatException2.getMessage());
                }
            }
        }
        return number;
    }

    public Number apply(int n) {
        return new LongNumber(n);
    }

    public Number apply(long n) {
        return new LongNumber(n);
    }

    public Number apply(double n) {
        return new BigDecimalNumber(package$.MODULE$.BigDecimal().apply(n));
    }

    public Number apply(BigInt n) {
        return new BigIntNumber(n);
    }

    public Number apply(BigDecimal n) {
        return new BigDecimalNumber(n);
    }

    private Number$() {
        MODULE$ = this;
        this.minDouble = package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue());
        this.maxDouble = package$.MODULE$.BigDecimal().apply(Double.MAX_VALUE);
    }
}

