/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.internal.cycle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCycleRemover<V, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphCycleRemover.class);
    private final Graph<V, T> originalGraph;
    private Comparator<V> cycleComparator;

    public GraphCycleRemover(Graph<V, T> originalGraph, Comparator<V> cycleComparator) {
        this.cycleComparator = cycleComparator;
        this.originalGraph = originalGraph;
    }

    public Graph<V, T> removeCycles() {
        SimpleDirectedGraph newGraph = new SimpleDirectedGraph(this.originalGraph.getVertexSupplier(), this.originalGraph.getEdgeSupplier(), this.originalGraph.getType().isWeighted());
        this.originalGraph.vertexSet().forEach(arg_0 -> ((SimpleDirectedGraph)newGraph).addVertex(arg_0));
        this.originalGraph.edgeSet().forEach(edge -> newGraph.addEdge(this.originalGraph.getEdgeSource(edge), this.originalGraph.getEdgeTarget(edge)));
        CycleDetector cycleDetector = new CycleDetector((Graph)newGraph);
        while (cycleDetector.detectCycles()) {
            ArrayList<V> cycles = new ArrayList<V>(cycleDetector.findCycles());
            cycles.sort(this.cycleComparator);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Cycles detected {}", cycles);
            }
            for (Object toVertex : cycles) {
                Optional<Object> fromVertexOptional = cycleDetector.findCyclesContainingVertex(toVertex).stream().filter(vertex -> newGraph.getEdge(vertex, toVertex) != null).findAny();
                if (!fromVertexOptional.isPresent()) continue;
                Object edgeRemoved = newGraph.removeEdge(fromVertexOptional.get(), toVertex);
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("Removing cycle edge {}", edgeRemoved);
            }
            cycleDetector = new CycleDetector((Graph)newGraph);
        }
        return newGraph;
    }
}

