/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.factories.FlowRefMessageProcessor;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.DeepSubFlowNestingFlowRefException;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.RecursiveFlowRefException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.chain.SubflowMessageProcessorChainBuilder;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class FlowRefFactoryBean
extends AbstractComponentFactory<Processor>
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private static final String APPLIED_FLOWREFS_KEY = "mule.flowref.appliedFlowrefsInReactorChain";
    private static final int MAX_SUB_FLOWS_SINGLE_CHAIN = Integer.getInteger("mule.flowRef.maxSubFlowsSingleChain", 10);
    public static final String MULE_TEST_FLOW_REF_MAX_SUB_FLOWS_SINGLE_CHAIN_FAIL = "mule.test.flowRef.maxSubFlowsSingleChain.fail";
    private String refName;
    private String target;
    private String targetValue = "#[payload]";
    private ApplicationContext applicationContext;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;
    @Inject
    private ComponentTracerFactory componentTracerFactory;

    public void setName(String name) {
        this.refName = name;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    @Override
    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new IllegalArgumentException("flow-ref name is empty");
        }
        if (this.expressionManager.isExpression(this.refName)) {
            return new DynamicFlowRefMessageProcessor(this, event -> (String)this.expressionManager.evaluate(this.refName, DataType.STRING, BindingContextUtils.NULL_BINDING_CONTEXT, (CoreEvent)event, this.getLocation(), true).getValue());
        }
        return new StaticFlowRefMessageProcessor(this, new DynamicFlowRefMessageProcessor(this, event -> this.refName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Processor getReferencedFlow(String name, FlowRefMessageProcessor flowRefMessageProcessor) throws MuleException {
        if (name == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("flow-ref name expression returned 'null'"), flowRefMessageProcessor);
        }
        Component referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("No flow/sub-flow with name '%s' found", name), flowRefMessageProcessor);
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof SubflowMessageProcessorChainBuilder) {
                SubflowMessageProcessorChainBuilder chainBuilder = (SubflowMessageProcessorChainBuilder)referencedFlow;
                chainBuilder.withComponentTracerFactory(this.componentTracerFactory);
                this.locator.find(flowRefMessageProcessor.getRootContainerLocation()).filter(c -> c instanceof Flow).map(c -> (Flow)c).ifPresent(f -> {
                    final ProcessingStrategy callerFlowPs = f.getProcessingStrategy();
                    chainBuilder.setProcessingStrategy(new ProcessingStrategy(){

                        @Override
                        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
                            return callerFlowPs.createSink(flowConstruct, pipeline);
                        }

                        @Override
                        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
                            return pipeline;
                        }

                        @Override
                        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
                            return callerFlowPs.onProcessor(processor);
                        }
                    });
                });
                referencedFlow = chainBuilder.build();
            }
            LifecycleUtils.initialiseIfNeeded(referencedFlow, this.muleContext);
            HashMap<QName, Object> annotations = new HashMap<QName, Object>(referencedFlow.getAnnotations());
            annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerLocation().toString());
            referencedFlow.setAnnotations(annotations);
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassLoader contextClassLoader = this.muleContext.getExecutionClassLoader();
            ClassUtils.setContextClassLoader(currentThread, currentClassLoader, contextClassLoader);
            try {
                LifecycleUtils.startIfNeeded(referencedFlow);
            }
            finally {
                ClassUtils.setContextClassLoader(currentThread, contextClassLoader, currentClassLoader);
            }
        }
        return (Processor)((Object)referencedFlow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getReferencedProcessor(String name) {
        if (this.applicationContext instanceof MuleArtifactContext) {
            MuleArtifactContext muleArtifactContext = (MuleArtifactContext)this.applicationContext;
            try {
                BeanDefinition processorBeanDefinition = muleArtifactContext.getBeanFactory().getBeanDefinition(name);
                if (processorBeanDefinition.isPrototype()) {
                    ApplicationContext applicationContext = this.applicationContext;
                    synchronized (applicationContext) {
                        this.updateBeanDefinitionRootContainerName(this.getRootContainerLocation().toString(), processorBeanDefinition);
                        return (Component)this.applicationContext.getBean(name);
                    }
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return (Component)this.applicationContext.getBean(name);
    }

    private void updateBeanDefinitionRootContainerName(String rootContainerName, BeanDefinition beanDefinition) {
        Class<?> beanClass = null;
        try {
            beanClass = Thread.currentThread().getContextClassLoader().loadClass(beanDefinition.getBeanClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (beanClass == null || Component.class.isAssignableFrom(beanClass)) {
            ComponentModelHelper.updateAnnotationValue(ROOT_CONTAINER_NAME_KEY, rootContainerName, beanDefinition);
        }
        for (PropertyValue propertyValue : beanDefinition.getPropertyValues().getPropertyValueList()) {
            Object value = propertyValue.getValue();
            this.processBeanValue(rootContainerName, value);
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : beanDefinition.getConstructorArgumentValues().getGenericArgumentValues()) {
            this.processBeanValue(rootContainerName, valueHolder.getValue());
        }
    }

    private void processBeanValue(String rootContainerName, Object value) {
        if (value instanceof BeanDefinition) {
            this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)value);
        } else if (value instanceof ManagedList) {
            ManagedList managedList = (ManagedList)value;
            for (Object itemValue : managedList) {
                if (!(itemValue instanceof BeanDefinition)) continue;
                this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)itemValue);
            }
        } else if (value instanceof ManagedMap) {
            ManagedMap managedMap = (ManagedMap)value;
            managedMap.forEach((key, mapValue) -> this.processBeanValue(rootContainerName, mapValue));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Function<MessagingException, Throwable> getMessagingExceptionMapper() {
        return me -> new MessagingException(EventQuickCopy.quickCopy((EventContext)((BaseEventContext)me.getEvent().getContext()).getParentContext().get(), me.getEvent()), (MessagingException)me);
    }

    private class DynamicFlowRefMessageProcessor
    extends FlowRefMessageProcessor {
        private final Function<CoreEvent, String> refNameFromEvent;
        private final LoadingCache<String, Processor> targetsCache;

        public DynamicFlowRefMessageProcessor(FlowRefFactoryBean owner, Function<CoreEvent, String> refNameFromEvent) {
            super(owner);
            this.refNameFromEvent = refNameFromEvent;
            this.targetsCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, DynamicFlowRefMessageProcessor.this);
                }
            });
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor resolvedTarget;
                try {
                    resolvedTarget = this.resolveTargetFlowOrSubflow((CoreEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                Optional<Flow> targetAsFlow = resolvedTarget instanceof Flow ? Optional.of((Flow)resolvedTarget) : Optional.empty();
                return Mono.from(this.processWithChildContextFlowOrSubflow((CoreEvent)event, resolvedTarget, targetAsFlow)).map(Operators.outputToTarget(event, FlowRefFactoryBean.this.target, FlowRefFactoryBean.this.targetValue, FlowRefFactoryBean.this.expressionManager));
            });
        }

        protected Publisher<CoreEvent> processWithChildContextFlowOrSubflow(CoreEvent event, ReactiveProcessor resolvedTarget, Optional<Flow> targetAsFlow) {
            Optional<ComponentLocation> componentLocation = Optional.ofNullable(this.getLocation());
            if (targetAsFlow.isPresent()) {
                return MessageProcessors.processWithChildContextDontComplete(event, p -> Mono.from((Publisher)p).transform((Function)((Flow)targetAsFlow.get()).referenced()).onErrorMap(MessagingException.class, FlowRefFactoryBean.this.getMessagingExceptionMapper()), componentLocation);
            }
            return Mono.just((Object)event).transform((Function)resolvedTarget).subscriberContext(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true));
        }

        protected Processor resolveTargetFlowOrSubflow(CoreEvent event) throws MuleException {
            try {
                return (Processor)this.targetsCache.getUnchecked((Object)this.refNameFromEvent.apply(event));
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                if (e.getCause() instanceof MuleException) {
                    throw (MuleException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void doStart() throws MuleException {
            for (Processor p : this.targetsCache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.startIfNeeded(p);
            }
        }

        @Override
        public void stop() throws MuleException {
            for (Processor p : this.targetsCache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded(p);
            }
        }

        @Override
        public void dispose() {
            for (Processor p : this.targetsCache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded(p, LOGGER);
            }
            this.targetsCache.invalidateAll();
            this.targetsCache.cleanUp();
        }
    }

    private class StaticFlowRefMessageProcessor
    extends FlowRefMessageProcessor {
        private final DynamicFlowRefMessageProcessor recursiveFallback;
        private final AtomicBoolean stoppedOnce;
        private final LazyValue<ReactiveProcessor> resolvedReferencedProcessorSupplier;
        private volatile boolean recursionFound;

        protected StaticFlowRefMessageProcessor(FlowRefFactoryBean owner, DynamicFlowRefMessageProcessor recursiveFallback) {
            super(owner);
            this.stoppedOnce = new AtomicBoolean(false);
            this.resolvedReferencedProcessorSupplier = new LazyValue<Supplier<ReactiveProcessor>>(() -> {
                try {
                    return FlowRefFactoryBean.this.getReferencedFlow(FlowRefFactoryBean.this.refName, this);
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(e);
                }
            });
            this.recursionFound = false;
            this.recursiveFallback = recursiveFallback;
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            if (this.recursionFound) {
                return Flux.from(publisher).transform((Function)this.recursiveFallback);
            }
            ReactiveProcessor resolvedReferencedProcessor = this.resolvedReferencedProcessorSupplier.get();
            Flux pub = Flux.from(publisher).subscriberContext(this.clearCurrentFlowRefFromCycleDetection());
            if (FlowRefFactoryBean.this.target != null) {
                pub = pub.map(event -> EventQuickCopy.quickCopy(event, Collections.singletonMap(this.originalEventKey((CoreEvent)event), event))).cast(CoreEvent.class);
            }
            Optional<ComponentLocation> location = Optional.ofNullable(this.getLocation());
            pub = resolvedReferencedProcessor instanceof Flow ? Flux.from(this.applyForStaticFlow((Flow)resolvedReferencedProcessor, (Flux<CoreEvent>)pub, location)) : (resolvedReferencedProcessor instanceof MessageProcessorChain ? Flux.from(this.applyForStaticSubFlow(resolvedReferencedProcessor, (Flux<CoreEvent>)pub, location)) : Flux.from(this.applyForStaticProcessor(resolvedReferencedProcessor, (Flux<CoreEvent>)pub, location)));
            Flux resumed = pub.onErrorResume(t -> t instanceof RecursiveFlowRefException, t -> {
                this.recursionFound = true;
                LOGGER.warn(t.toString());
                return Flux.from((Publisher)publisher).transform((Function)this.recursiveFallback);
            });
            return resumed.onErrorResume(t -> t instanceof DeepSubFlowNestingFlowRefException, t -> {
                LOGGER.debug(t.toString());
                return Flux.from((Publisher)publisher).transform((Function)this.recursiveFallback);
            });
        }

        private Publisher<CoreEvent> applyForStaticFlow(Flow resolvedTarget, Flux<CoreEvent> pub, Optional<ComponentLocation> location) {
            return this.decoratePublisher((Flux<CoreEvent>)pub.transform(eventPub -> MessageProcessors.applyWithChildContextDontPropagateErrors((Publisher<CoreEvent>)eventPub, resolvedTarget.referenced(), location)));
        }

        private Publisher<CoreEvent> applyForStaticSubFlow(ReactiveProcessor resolvedTarget, Flux<CoreEvent> pub, Optional<ComponentLocation> location) {
            return this.decoratePublisher((Flux<CoreEvent>)pub.transform((Function)resolvedTarget));
        }

        private Publisher<CoreEvent> applyForStaticProcessor(ReactiveProcessor resolvedTarget, Flux<CoreEvent> pub, Optional<ComponentLocation> location) {
            return this.decoratePublisher((Flux<CoreEvent>)pub.transform(eventPub -> eventPub.flatMap(event -> Mono.just((Object)event).transform((Function)resolvedTarget))));
        }

        private Publisher<CoreEvent> decoratePublisher(Flux<CoreEvent> pub) {
            pub = pub.subscriberContext(this.checkAndMarkCurrentFlowRefForCycleDetection());
            return FlowRefFactoryBean.this.target != null ? pub.map(eventAfter -> Operators.outputToTarget((CoreEvent)((InternalEvent)eventAfter).getInternalParameter(this.originalEventKey((CoreEvent)eventAfter)), FlowRefFactoryBean.this.target, FlowRefFactoryBean.this.targetValue, FlowRefFactoryBean.this.expressionManager).apply((CoreEvent)eventAfter)) : pub;
        }

        protected Function<Context, Context> clearCurrentFlowRefFromCycleDetection() {
            return context -> {
                ArrayList currentAppliedFlowrefs = new ArrayList((Collection)context.getOrDefault((Object)FlowRefFactoryBean.APPLIED_FLOWREFS_KEY, Collections.emptyList()));
                currentAppliedFlowrefs.remove(FlowRefFactoryBean.this.refName);
                return context.put((Object)FlowRefFactoryBean.APPLIED_FLOWREFS_KEY, currentAppliedFlowrefs);
            };
        }

        private Function<Context, Context> checkAndMarkCurrentFlowRefForCycleDetection() {
            return context -> {
                ArrayList<String> currentAppliedFlowrefs = new ArrayList<String>((Collection)context.getOrDefault((Object)FlowRefFactoryBean.APPLIED_FLOWREFS_KEY, Collections.emptyList()));
                if (currentAppliedFlowrefs.contains(FlowRefFactoryBean.this.refName)) {
                    ArrayList<String> forMessage = new ArrayList<String>(currentAppliedFlowrefs);
                    forMessage.add(FlowRefFactoryBean.this.refName);
                    throw Exceptions.propagate((Throwable)new RecursiveFlowRefException(currentAppliedFlowrefs.stream().collect(Collectors.joining("' -> '", "'", "'")), this));
                }
                if (currentAppliedFlowrefs.size() > MAX_SUB_FLOWS_SINGLE_CHAIN) {
                    ArrayList<String> forMessage = new ArrayList<String>(currentAppliedFlowrefs);
                    forMessage.add(FlowRefFactoryBean.this.refName);
                    throw Exceptions.propagate((Throwable)new DeepSubFlowNestingFlowRefException(forMessage.stream().collect(Collectors.joining("' -> '", "'", "'")), this));
                }
                currentAppliedFlowrefs.add(FlowRefFactoryBean.this.refName);
                return context.put((Object)FlowRefFactoryBean.APPLIED_FLOWREFS_KEY, currentAppliedFlowrefs);
            };
        }

        protected String originalEventKey(CoreEvent event) {
            return "flowRef.originalEvent." + event.getContext().getId() + this.getLocation().getLocation();
        }

        @Override
        public void doStart() throws MuleException {
            if (this.stoppedOnce.get() && this.targetIsComputedAndSubFlow()) {
                LifecycleUtils.startIfNeeded(this.resolvedReferencedProcessorSupplier.get());
            }
        }

        @Override
        public void stop() throws MuleException {
            if (this.targetIsComputedAndSubFlow()) {
                LifecycleUtils.stopIfNeeded(this.resolvedReferencedProcessorSupplier.get());
                this.stoppedOnce.set(true);
            }
        }

        @Override
        public void dispose() {
            if (this.targetIsComputedAndSubFlow()) {
                LifecycleUtils.disposeIfNeeded(this.resolvedReferencedProcessorSupplier.get(), LOGGER);
            }
        }

        protected boolean targetIsComputedAndSubFlow() {
            return this.resolvedReferencedProcessorSupplier.isComputed() && !(this.resolvedReferencedProcessorSupplier.get() instanceof Flow);
        }

        @Override
        public void setAnnotations(Map<QName, Object> newAnnotations) {
            super.setAnnotations(newAnnotations);
            this.recursiveFallback.setAnnotations(newAnnotations);
        }
    }
}

