/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.AbstractConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;

public final class ErrorTypeHandlerConnectionProviderWrapper<C>
extends AbstractConnectionProviderWrapper<C> {
    private final ErrorTypeRepository errorTypeRepository;
    private final String prefix;
    private final ReconnectionConfig reconnectionConfig;

    public ErrorTypeHandlerConnectionProviderWrapper(ConnectionProvider<C> connectionProvider, ExtensionModel extensionModel, ReconnectionConfig reconnectionConfig, ErrorTypeRepository errorTypeRepository) {
        super(connectionProvider);
        this.errorTypeRepository = errorTypeRepository;
        this.prefix = extensionModel.getXmlDslModel().getPrefix().toUpperCase();
        this.reconnectionConfig = reconnectionConfig;
    }

    @Override
    public C connect() throws ConnectionException {
        try {
            return this.getDelegate().connect();
        }
        catch (ConnectionException e) {
            Throwable cause = e.getCause();
            throw this.getErrorType(cause).map(errorType -> e.getClass().equals(ConnectionException.class) ? new ConnectionException(e.getMessage(), e.getCause(), (ErrorType)errorType) : new ConnectionException(e.getMessage(), e, (ErrorType)errorType)).orElse(e);
        }
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        ConnectionValidationResult originalResult = this.getDelegate().validate(connection);
        if (originalResult.isValid()) {
            return originalResult;
        }
        Exception exception = originalResult.getException();
        return this.getErrorType(exception).map(type -> ConnectionValidationResult.failure(originalResult.getMessage(), type, exception)).orElse(originalResult);
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getRetryPolicyTemplate() : super.getRetryPolicyTemplate();
    }

    @Override
    public Optional<ReconnectionConfig> getReconnectionConfig() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getReconnectionConfig() : Optional.ofNullable(this.reconnectionConfig);
    }

    private Optional<ErrorType> getErrorType(Throwable exception) {
        if (exception instanceof org.mule.runtime.extension.api.exception.ModuleException) {
            return this.getErrorType(((org.mule.runtime.extension.api.exception.ModuleException)exception).getType());
        }
        if (exception instanceof ModuleException) {
            return this.getErrorType(((ModuleException)exception).getType());
        }
        return exception != null && exception.getCause() != null ? this.getErrorType(exception.getCause()) : Optional.empty();
    }

    private Optional<ErrorType> getErrorType(org.mule.runtime.extension.api.error.ErrorTypeDefinition errorType) {
        return this.errorTypeRepository.getErrorType(this.getIdentifier(errorType));
    }

    private Optional<ErrorType> getErrorType(ErrorTypeDefinition errorType) {
        return this.errorTypeRepository.getErrorType(this.getIdentifier(errorType));
    }

    private ComponentIdentifier getIdentifier(org.mule.runtime.extension.api.error.ErrorTypeDefinition errorType) {
        return ComponentIdentifier.builder().name(errorType.getType()).namespace(this.prefix).build();
    }

    private ComponentIdentifier getIdentifier(ErrorTypeDefinition errorType) {
        return ComponentIdentifier.builder().name(errorType.getType()).namespace(this.prefix).build();
    }
}

