/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.management.stats.ProcessingTime;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.event.AbstractEventContext;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.streaming.EventStreamingState;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.tracer.api.context.SpanContext;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultEventContext
extends AbstractEventContext
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventContext.class);
    private static final long serialVersionUID = -3664490832964509653L;
    private transient SpanContext distributedTraceContext;
    private final String id;
    private final String correlationId;
    private final Instant receivedDate = Instant.now();
    private final String serverId;
    private final ComponentLocation location;
    private ProcessingTime processingTime;
    private transient EventStreamingState streamingState;

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation) {
        return DefaultEventContext.child(parent, componentLocation, NullExceptionHandler.getInstance());
    }

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation, String correlationId) {
        return DefaultEventContext.child(parent, componentLocation, NullExceptionHandler.getInstance(), correlationId);
    }

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        return DefaultEventContext.child(parent, componentLocation, exceptionHandler, null);
    }

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler, String correlationId) {
        ChildEventContext child = new ChildEventContext(parent, componentLocation.orElse(null), exceptionHandler, parent.getDepthLevel() + 1, correlationId);
        if (parent instanceof AbstractEventContext) {
            ((AbstractEventContext)parent).addChildContext(child);
        }
        return child;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRootId() {
        return this.getRootContext().getCorrelationId();
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? this.correlationId : this.id;
    }

    @Override
    public Instant getReceivedTime() {
        return this.receivedDate;
    }

    @Override
    public ComponentLocation getOriginatingLocation() {
        return this.location;
    }

    @Override
    public Optional<ProcessingTime> getProcessingTime() {
        return Optional.ofNullable(this.processingTime);
    }

    @Override
    public boolean isCorrelationIdFromSource() {
        return this.correlationId != null;
    }

    @Override
    public FlowCallStack getFlowCallStack() {
        return this.flowCallStack;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return () -> Collections.emptyList();
    }

    @Override
    public Optional<BaseEventContext> getParentContext() {
        return Optional.empty();
    }

    @Override
    public BaseEventContext getRootContext() {
        return this;
    }

    public DefaultEventContext(FlowConstruct flow, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        super(NullExceptionHandler.getInstance(), 0, externalCompletion);
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.location = location;
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
        if (flow != null && flow.getMuleContext() != null) {
            this.eventContextMaintain(flow.getMuleContext().getEventContextService());
        }
        this.flowCallStack = new DefaultFlowCallStack();
        this.createStreamingState();
    }

    public DefaultEventContext(FlowConstruct flow, FlowExceptionHandler exceptionHandler, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        super(exceptionHandler, 0, externalCompletion);
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.location = location;
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
        if (flow != null && flow.getMuleContext() != null) {
            this.eventContextMaintain(flow.getMuleContext().getEventContextService());
        }
        this.flowCallStack = new DefaultFlowCallStack();
        this.createStreamingState();
    }

    public DefaultEventContext(String id, String serverId, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        this(id, serverId, location, correlationId, externalCompletion, NullExceptionHandler.getInstance());
    }

    @Deprecated
    public DefaultEventContext(String id, String serverId, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion, FlowExceptionHandler exceptionHandler) {
        super(exceptionHandler, 0, externalCompletion);
        this.id = id;
        this.serverId = serverId;
        this.location = location;
        this.processingTime = null;
        this.correlationId = correlationId;
        this.flowCallStack = new DefaultFlowCallStack();
        this.createStreamingState();
    }

    void createStreamingState() {
        if (this.streamingState == null) {
            this.initCompletionLists();
            this.streamingState = new EventStreamingState();
            this.onTerminated((event, e) -> this.streamingState.dispose());
        }
    }

    public CursorProvider track(ManagedCursorProvider provider, StreamingGhostBuster ghostBuster) {
        return this.streamingState.addProvider(provider, ghostBuster);
    }

    private void eventContextMaintain(EventContextService eventContextService) {
        if (eventContextService != null && eventContextService instanceof DefaultEventContextService) {
            ((DefaultEventContextService)eventContextService).addContext(this);
            this.onTerminated((e, t) -> ((DefaultEventContextService)eventContextService).removeContext(this));
        }
    }

    public String toString() {
        if (LOGGER.isTraceEnabled()) {
            return System.lineSeparator() + this.detailedToString(0, this) + System.lineSeparator();
        }
        return this.basicToString();
    }

    @Override
    protected String basicToString() {
        return this.getClass().getSimpleName() + " { state: " + this.getState() + "; id: " + this.id + "; flowName: " + this.getOriginatingLocation().getRootContainerName() + " }";
    }

    @Override
    public SpanContext getSpanContext() {
        return this.distributedTraceContext;
    }

    @Override
    public void setSpanContext(SpanContext distributedTraceContext) {
        this.distributedTraceContext = distributedTraceContext;
    }

    private static class ChildEventContext
    extends AbstractEventContext
    implements Serializable {
        private static final long serialVersionUID = 1054412872901205234L;
        private transient BaseEventContext root;
        private final BaseEventContext parent;
        private final ComponentLocation componentLocation;
        private final String id;
        private final String correlationId;
        private transient SpanContext spanContext;
        private final String rootId;

        private ChildEventContext(BaseEventContext parent, ComponentLocation componentLocation, FlowExceptionHandler messagingExceptionHandler, int depthLevel, String correlationId) {
            super(messagingExceptionHandler, depthLevel, Optional.empty());
            SpanContext parentSpanContext;
            this.flowCallStack = parent.getFlowCallStack().clone();
            this.root = parent.getRootContext();
            this.parent = parent;
            this.componentLocation = componentLocation;
            this.id = parent.getId() != null ? parent.getId().concat("_").concat(Integer.toString(System.identityHashCode(this))) : Integer.toString(System.identityHashCode(this));
            this.correlationId = correlationId != null ? correlationId : parent.getCorrelationId();
            this.rootId = this.root.getRootId();
            if (parent instanceof SpanContextAware && (parentSpanContext = this.getParentDistributedTraceContext((SpanContextAware)((Object)parent))) != null) {
                this.spanContext = parentSpanContext.copy();
            }
        }

        private SpanContext getParentDistributedTraceContext(SpanContextAware parent) {
            return parent.getSpanContext();
        }

        private ChildEventContext(BaseEventContext parent, ComponentLocation componentLocation, FlowExceptionHandler messagingExceptionHandler, int depthLevel) {
            this(parent, componentLocation, messagingExceptionHandler, depthLevel, null);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getRootId() {
            return this.rootId;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public SpanContext getSpanContext() {
            return this.spanContext;
        }

        @Override
        public void setSpanContext(SpanContext spanContext) {
            this.spanContext = spanContext;
        }

        @Override
        public Instant getReceivedTime() {
            return this.parent.getReceivedTime();
        }

        @Override
        public ComponentLocation getOriginatingLocation() {
            return this.parent.getOriginatingLocation();
        }

        @Override
        public Optional<ProcessingTime> getProcessingTime() {
            return this.parent.getProcessingTime();
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        @Override
        public ProcessorsTrace getProcessorsTrace() {
            return this.parent.getProcessorsTrace();
        }

        @Override
        public boolean isCorrelationIdFromSource() {
            return this.parent.isCorrelationIdFromSource();
        }

        @Override
        public BaseEventContext getRootContext() {
            if (this.root == null) {
                this.root = this.parent.getRootContext();
            }
            return this.root;
        }

        public String toString() {
            if (LOGGER.isTraceEnabled()) {
                return System.lineSeparator() + ((AbstractEventContext)this.root).detailedToString(0, this) + System.lineSeparator();
            }
            return this.basicToString();
        }

        @Override
        public String basicToString() {
            return this.getClass().getSimpleName() + " { state: " + this.getState() + "; id: " + this.getId() + "; componentLocation: " + (this.componentLocation != null ? this.componentLocation.getLocation() : "") + " }";
        }

        @Override
        public Optional<BaseEventContext> getParentContext() {
            return Optional.of(this.parent);
        }
    }
}

