/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public final class JarLoadingUtils {
    private static final Logger logger = LoggerFactory.getLogger(JarLoadingUtils.class);

    private JarLoadingUtils() {
    }

    public static java.net.JarURLConnection getJarConnection(URL possibleUrl) throws MalformedURLException, IOException {
        JarURLConnection jarConnection = new JarURLConnection(possibleUrl, new Handler());
        return jarConnection;
    }

    public static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI().toString() + "!/" + filePath);
    }

    public static Optional<byte[]> loadFileContentFrom(File jarFile, String filePath) throws IOException {
        Optional<byte[]> optional;
        block8: {
            URL jsonDescriptorUrl = JarLoadingUtils.getUrlWithinJar(jarFile, filePath);
            JarURLConnection jarConnection = new JarURLConnection(jsonDescriptorUrl, new Handler());
            ((URLConnection)jarConnection).setUseCaches(false);
            InputStream inputStream = ((URLConnection)jarConnection).getInputStream();
            try {
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                optional = Optional.of(byteArray);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        Optional<byte[]> optional;
        block8: {
            JarURLConnection jarConnection = new JarURLConnection(jarFile, new Handler());
            ((URLConnection)jarConnection).setUseCaches(false);
            InputStream inputStream = ((URLConnection)jarConnection).getInputStream();
            try {
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                optional = Optional.of(byteArray);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }
}

