/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.QueryBuilder;
import org.mule.runtime.extension.internal.dsql.MuleDsqlLexer;
import org.mule.runtime.extension.internal.dsql.MuleDsqlParser;
import org.mule.runtime.extension.internal.exception.DsqlParsingException;
import org.mule.runtime.extension.internal.grammar.BaseDsqlNode;
import org.mule.runtime.extension.internal.grammar.DefaultDsqlGrammarVisitor;
import org.mule.runtime.extension.internal.grammar.DsqlTreeAdaptor;

public final class DefaultDsqlParser
extends DsqlParser {
    private static final String DSQL_QUERY_PREFIX = "dsql:";

    public static DefaultDsqlParser getInstance() {
        return new DefaultDsqlParser();
    }

    public static boolean isDsqlQuery(String query) {
        return query.length() > 5 && query.toLowerCase().startsWith(DSQL_QUERY_PREFIX);
    }

    @Override
    public DsqlQuery parse(String dsqlQuery) {
        if (!DefaultDsqlParser.isDsqlQuery(dsqlQuery)) {
            throw new IllegalArgumentException("Invalid Query: DSQL queries must start with the [dsql:] prefix");
        }
        MuleDsqlLexer dsqlLexer = new MuleDsqlLexer((CharStream)new ANTLRStringStream(dsqlQuery.substring(5)));
        CommonTokenStream dsqlTokens = new CommonTokenStream();
        dsqlTokens.setTokenSource((TokenSource)dsqlLexer);
        MuleDsqlParser dsqlParser = new MuleDsqlParser((TokenStream)dsqlTokens);
        dsqlParser.setTreeAdaptor((TreeAdaptor)new DsqlTreeAdaptor());
        return this.parse(dsqlParser);
    }

    private DsqlQuery parse(MuleDsqlParser dsqlParser) {
        try {
            MuleDsqlParser.select_return select2 = dsqlParser.select();
            BaseDsqlNode tree = (BaseDsqlNode)select2.getTree();
            return this.buildQuery(tree).build();
        }
        catch (IllegalArgumentException | RecognitionException e) {
            throw new DsqlParsingException(e);
        }
    }

    private QueryBuilder buildQuery(BaseDsqlNode dsqlRootNode) {
        DefaultDsqlGrammarVisitor visitor = new DefaultDsqlGrammarVisitor();
        dsqlRootNode.accept(visitor);
        return visitor.getQueryBuilder();
    }
}

