/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class ObjectTypeParameterParser
extends ExtensionDefinitionParser {
    private final ObjectType type;
    private final ClassLoader classLoader;
    private final DslElementSyntax typeDsl;
    private final String name;
    private final String namespace;

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, dslResolver, context);
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = dslResolver.resolve(type).orElseThrow(() -> new IllegalArgumentException(String.format("Non parseable object of type [%s]", ExtensionMetadataTypeUtils.getId(type))));
        this.name = this.typeDsl.getElementName();
        this.namespace = this.typeDsl.getPrefix();
    }

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, String name, String namespace, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, dslResolver, context);
        this.name = name;
        this.namespace = namespace;
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = dslResolver.resolve(type).orElseThrow(() -> new IllegalArgumentException(String.format("Non parseable object [%s:%s] of type [%s]", name, namespace, ExtensionMetadataTypeUtils.getId(type))));
    }

    @Override
    protected ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        ComponentBuildingDefinition.Builder<ValueResolver> finalBuilder = definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.type).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("name", AttributeDefinition.Builder.fromSimpleParameter("name").build());
        this.parseFields(this.type, this.typeDsl);
        return finalBuilder;
    }
}

