/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ConfigurationInstanceNotification;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectivityTester;
import org.mule.runtime.core.internal.connection.ConnectivityTesterFactory;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultMutableConfigurationStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecycleAwareConfigurationInstance
implements ConfigurationInstance,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleAwareConfigurationInstance.class);
    private final String name;
    private final ConfigurationModel model;
    private final Object value;
    private final ConfigurationState configurationState;
    private final Optional<ConnectionProvider> connectionProvider;
    private ConfigurationStats configurationStats;
    @Inject
    private TimeSupplier timeSupplier;
    @Inject
    private NotificationDispatcher notificationFirer;
    @Inject
    private ConnectionManagerAdapter connectionManager;
    @Inject
    private ConnectivityTesterFactory connectivityTesterFactory;
    @Inject
    private MuleContext muleContext;
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private ConnectivityTester connectivityTester;

    public LifecycleAwareConfigurationInstance(String name, ConfigurationModel model, Object value, ConfigurationState configurationState, Optional<ConnectionProvider> connectionProvider) {
        this.name = name;
        this.model = model;
        this.value = value;
        this.configurationState = configurationState;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Initializing LifecycleAwareConfigurationInstance '%s'", this.getName()));
        }
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.initStats();
                this.doInitialise();
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error initializing LifecycleAwareConfigurationInstance '%s'", this.getName()), (Throwable)e);
                if (e instanceof InitialisationException) {
                    throw (InitialisationException)e;
                }
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public synchronized void start() throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Starting LifecycleAwareConfigurationInstance '%s'", this.getName()));
        }
        if (!this.started) {
            this.started = true;
            if (this.connectionProvider.isPresent()) {
                LifecycleUtils.startIfNeeded(this.connectionProvider);
                if (!this.connectionManager.hasBinding(this.value)) {
                    this.connectionManager.bind(this.value, this.connectionProvider.get());
                }
                this.connectivityTester = this.connectivityTesterFactory.create(this.getName());
                this.connectivityTester.testConnectivity(this.connectionProvider.get(), this);
            }
            LifecycleUtils.startIfNeeded(this.value);
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Stopping LifecycleAwareConfigurationInstance '%s'", this.getName()));
        }
        if (this.started) {
            this.started = false;
            try {
                LifecycleUtils.stopIfNeeded(this.value);
                if (this.connectionProvider.isPresent()) {
                    if (this.connectivityTester == null) {
                        this.unbindConnection();
                    } else {
                        this.connectivityTester.withTestConnectivityLock(this::unbindConnection);
                    }
                }
                this.connectivityTester = null;
            }
            finally {
                this.notificationFirer.dispatch(new ConfigurationInstanceNotification(this, ConfigurationInstanceNotification.CONFIGURATION_STOPPED));
            }
        }
    }

    protected void unbindConnection() throws MuleException {
        this.connectionManager.unbind(this.value);
        LifecycleUtils.stopIfNeeded(this.connectionProvider);
    }

    @Override
    public synchronized void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Disposing LifecycleAwareConfigurationInstance '%s'", this.getName()));
        }
        if (this.initialized) {
            this.initialized = false;
            LifecycleUtils.disposeIfNeeded(this.value, LOGGER);
            LifecycleUtils.disposeIfNeeded(this.connectionProvider, LOGGER);
            this.configurationStats = null;
        }
    }

    private void doInitialise() throws InitialisationException {
        if (this.connectionProvider.isPresent()) {
            LifecycleUtils.initialiseIfNeeded(this.connectionProvider, true, this.muleContext);
            this.connectionManager.bind(this.value, this.connectionProvider.get());
        }
        LifecycleUtils.initialiseIfNeeded(this.value, true, this.muleContext);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<ConnectionProvider> getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public ConfigurationModel getModel() {
        return this.model;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public ConfigurationStats getStatistics() {
        Preconditions.checkState(this.configurationStats != null, "can't get statistics before initialise() is invoked");
        return this.configurationStats;
    }

    @Override
    public ConfigurationState getState() {
        return this.configurationState;
    }

    private void initStats() {
        if (this.timeSupplier == null) {
            this.timeSupplier = new LocalTimeSupplier();
        }
        this.configurationStats = new DefaultMutableConfigurationStats(this.timeSupplier);
    }
}

