/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.reflections.ReflectionUtils;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<Class<? extends Service>, Service> services = new HashMap<Class<? extends Service>, Service>();

    public void inject(ServiceProvider serviceProvider) throws ServiceResolutionError {
        for (Field field : ReflectionUtils.getAllFields(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            Class dependencyType = field.getType();
            boolean asOptional = false;
            if (dependencyType.equals(Optional.class)) {
                Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                dependencyType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
                asOptional = true;
            }
            try {
                field.setAccessible(true);
                Object dependency = this.resolveObjectToInject(dependencyType, asOptional);
                if (dependency != null) {
                    field.set(serviceProvider, dependency);
                    continue;
                }
                if (asOptional) continue;
                throw new ServiceResolutionError(String.format("Cannot find a service to inject into field '%s' of service provider '%s'", field.getName(), serviceProvider.getServiceDefinition().getServiceClass().getName()));
            }
            catch (Exception e) {
                throw new ServiceResolutionError(String.format("Could not inject dependency on field %s of type %s", field.getName(), dependencyType.getName()), e);
            }
        }
    }

    private Object resolveObjectToInject(Class<?> dependencyType, boolean asOptional) {
        Optional<Object> dependency = this.services.entrySet().stream().filter(entry -> dependencyType.isAssignableFrom((Class)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
        return asOptional ? Optional.ofNullable(dependency) : dependency;
    }

    @Override
    public <S extends Service> void register(S service, Class<? extends S> serviceContract) {
        this.services.put(serviceContract, service);
    }

    public <S extends Service> void register(Class<? extends S> serviceContract, S service) {
        this.services.put(serviceContract, service);
    }

    @Override
    public <S extends Service> void unregister(Class<? extends S> serviceContract) {
        this.services.remove(serviceContract);
    }

    @Override
    public <S extends Service> Optional<S> getService(Class<? extends S> serviceInterface) {
        return this.services.values().stream().filter(s -> serviceInterface.isInstance(s)).map(s -> s).findAny();
    }

    @Override
    public Collection<Service> getAllServices() {
        return new HashSet<Service>(this.services.values());
    }
}

