/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.csv.writer;

import java.io.OutputStream;
import java.io.Serializable;
import org.mule.weave.v2.core.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.core.csv.CSVDataFormat;
import org.mule.weave.v2.module.core.csv.reader.parser.CSVSettingsHelper;
import org.mule.weave.v2.module.core.csv.reader.parser.CSVWriterSettings;
import org.mule.weave.v2.module.core.csv.writer.CSVWriter$;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\f\u0019\u0001%B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011)\u0019!C\u0001\u007f!A\u0001\n\u0001B\u0001B\u0003%\u0001\t\u0003\u0005J\u0001\t\u0005\t\u0015a\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011!I\u0002\u0001#b\u0001\n\u0003A\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011A/\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u0019\u0004A\u0011K4\t\u000by\u0004A\u0011A@\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!!&\u0001\t\u0003\n9\nC\u0004\u0002\u001a\u0002!\t%a&\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\u001e9\u00111\u0018\r\t\u0002\u0005ufAB\f\u0019\u0011\u0003\ty\f\u0003\u0004Q)\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u0007$B\u0011AAc\u0005%\u00195KV,sSR,'O\u0003\u0002\u001a5\u00051qO]5uKJT!a\u0007\u000f\u0002\u0007\r\u001chO\u0003\u0002\u001e=\u0005!1m\u001c:f\u0015\ty\u0002%\u0001\u0004n_\u0012,H.\u001a\u0006\u0003C\t\n!A\u001e\u001a\u000b\u0005\r\"\u0013!B<fCZ,'BA\u0013'\u0003\u0011iW\u000f\\3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011gM\u0007\u0002e)\u0011\u0011DH\u0005\u0003iI\u0012aa\u0016:ji\u0016\u0014\u0018AA8t!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u00051yU\u000f\u001e9viN#(/Z1n\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015A\u00029beN,'O\u0003\u0002F5\u00051!/Z1eKJL!a\u0012\"\u0003#\r\u001bfk\u0016:ji\u0016\u00148+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005\u00191\r\u001e=\u0011\u0005-sU\"\u0001'\u000b\u00055\u0003\u0013!B7pI\u0016d\u0017BA(M\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I3v\u000b\u0006\u0002T+B\u0011A\u000bA\u0007\u00021!)\u0011*\u0002a\u0002\u0015\")Q'\u0002a\u0001m!)a(\u0002a\u0001\u0001V\t\u0011\f\u0005\u000225&\u00111L\r\u0002\u0011\u0005V4g-\u001a:fI&{uK]5uKJ\f\u0011bY:w\u000bN\u001c\u0017\r]3\u0016\u0003y\u0003\"!Q0\n\u0005\u0001\u0014%!E\"T-N+G\u000f^5oONDU\r\u001c9fe\u00061!/Z:vYR,\u0012a\u0019\t\u0003W\u0011L!!\u001a\u0017\u0003\u0007\u0005s\u00170\u0001\u0007e_^\u0013\u0018\u000e^3WC2,X\r\u0006\u0002i[R\u0011\u0011\u000e\u001c\t\u0003W)L!a\u001b\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013&\u0001\u001dA\u0013\u0005\u0006]&\u0001\ra\\\u0001\u0006m\u0006dW/\u001a\u0019\u0003ab\u00042!\u001d;w\u001b\u0005\u0011(BA:M\u0003\u00191\u0018\r\\;fg&\u0011QO\u001d\u0002\u0006-\u0006dW/\u001a\t\u0003obd\u0001\u0001B\u0005z[\u0006\u0005\t\u0011!B\u0001u\n\u0019q\fJ\u0019\u0012\u0005m\u001c\u0007CA\u0016}\u0013\tiHFA\u0004O_RD\u0017N\\4\u0002\u0017]\u0014\u0018\u000e^3IK\u0006$WM\u001d\u000b\u0005\u0003\u0003\t)\u0001F\u0002j\u0003\u0007AQ!\u0013\u0006A\u0004)CaA\u001c\u0006A\u0002\u0005\u001d\u0001\u0007BA\u0005\u0003\u001b\u0001B!\u001d;\u0002\fA\u0019q/!\u0004\u0005\u0017\u0005=\u0011QAA\u0001\u0002\u0003\u0015\tA\u001f\u0002\u0004?\u0012\u0012\u0014\u0001C<sSR,7i\u0015,\u0015\t\u0005U\u0011\u0011\u0004\u000b\u0004S\u0006]\u0001\"B%\f\u0001\bQ\u0005bBA\u000e\u0017\u0001\u0007\u0011QD\u0001\tSR,'/\u0019;peB1\u0011qDA\u0018\u0003kqA!!\t\u0002,9!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(!\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0007\u00055B&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011Q\u0006\u00171\t\u0005]\u00121\b\t\u0005cR\fI\u0004E\u0002x\u0003w!1\"!\u0010\u0002\u001a\u0005\u0005\t\u0011!B\u0001u\n\u0019q\fJ\u001a\u0002\u0015]\u0014\u0018\u000e^3F]R\u0014\u0018\u0010\u0006\u0003\u0002D\u0005\u001dCcA5\u0002F!)\u0011\n\u0004a\u0002\u0015\"1a\u000e\u0004a\u0001\u0003\u0013\u0002D!a\u0013\u0002PA!\u0011\u000f^A'!\r9\u0018q\n\u0003\f\u0003#\n9%!A\u0001\u0002\u000b\u0005!PA\u0002`IU\n\u0001c\u001e:ji\u0016\u001cFO]5oOZ\u000bG.^3\u0015\u000b%\f9&!\u001b\t\r9l\u0001\u0019AA-!\u0011\tY&a\u0019\u000f\t\u0005u\u0013q\f\t\u0004\u0003Ga\u0013bAA1Y\u00051\u0001K]3eK\u001aLA!!\u001a\u0002h\t11\u000b\u001e:j]\u001eT1!!\u0019-\u0011\u001d\tY'\u0004a\u0001\u0003[\n1\"];pi\u00164\u0016\r\\;fgB\u00191&a\u001c\n\u0007\u0005EDFA\u0004C_>dW-\u00198\u0002\u0017]\u0014\u0018\u000e^3SK\u000e|'\u000f\u001a\u000b\u0005\u0003o\nY\bF\u0002j\u0003sBQ!\u0013\bA\u0004)Cq!a\u0007\u000f\u0001\u0004\ti\b\u0005\u0004\u0002 \u0005=\u0012q\u0010\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011'\u0002\u0013M$(/^2ukJ,\u0017\u0002BAE\u0003\u0007\u0013AbS3z-\u0006dW/\u001a)bSJ\f\u0011b]3qCJ\fGo\u001c:\u0016\u0005\u0005=\u0005cA\u0016\u0002\u0012&\u0019\u00111\u0013\u0017\u0003\t\rC\u0017M]\u0001\u0006G2|7/\u001a\u000b\u0002S\u0006)a\r\\;tQ\u0006QA-\u0019;b\r>\u0014X.\u0019;\u0016\u0005\u0005}\u0005#B\u0016\u0002\"\u0006\u0015\u0016bAARY\t1q\n\u001d;j_:\u0004d!a*\u00022\u0006]\u0006\u0003CAU\u0003W\u000by+!.\u000e\u0003yI1!!,\u001f\u0005)!\u0015\r^1G_Jl\u0017\r\u001e\t\u0004o\u0006EFACAZ%\u0005\u0005\t\u0011!B\u0001u\n\u0019q\f\n\u001c\u0011\u0007]\f9\f\u0002\u0006\u0002:J\t\t\u0011!A\u0003\u0002i\u00141a\u0018\u00138\u0003%\u00195KV,sSR,'\u000f\u0005\u0002U)M\u0011AC\u000b\u000b\u0003\u0003{\u000bQ!\u00199qYf$b!a2\u0002L\u0006UGcA*\u0002J\")\u0011J\u0006a\u0002\u0015\"9\u0011Q\u001a\fA\u0002\u0005=\u0017A\u0001;q!\r\t\u0014\u0011[\u0005\u0004\u0003'\u0014$A\u0004+be\u001e,G\u000f\u0015:pm&$WM\u001d\u0005\u0006}Y\u0001\r\u0001\u0011")
public class CSVWriter
implements Writer {
    private BufferedIOWriter writer;
    private CSVSettingsHelper csvEscape;
    private final OutputStream os;
    private final CSVWriterSettings settings;
    private final EvaluationContext ctx;
    private volatile byte bitmap$0;

    public static CSVWriter apply(TargetProvider targetProvider, CSVWriterSettings cSVWriterSettings, EvaluationContext evaluationContext) {
        return CSVWriter$.MODULE$.apply(targetProvider, cSVWriterSettings, evaluationContext);
    }

    @Override
    public boolean supportsStreaming() {
        return Writer.supportsStreaming$(this);
    }

    @Override
    public void startDocument(LocationCapable location) {
        Writer.startDocument$(this, location);
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$(this, location, prefix, uri);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value, ctx);
    }

    @Override
    public CSVWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, this.settings().charset(this.ctx), this.settings().bufferSize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writer;
    }

    public BufferedIOWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private CSVSettingsHelper csvEscape$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.csvEscape = new CSVSettingsHelper(this.settings(), this.ctx.serviceManager().settingsService());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.csvEscape;
    }

    public CSVSettingsHelper csvEscape() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.csvEscape$lzycompute() : this.csvEscape;
    }

    @Override
    public Object result() {
        return this.os;
    }

    @Override
    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Object obj = value.evaluate(ctx);
        if (obj instanceof ArraySeq) {
            Object obj2 = obj;
            this.writeCSV(((ArraySeq)obj2).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (obj instanceof ObjectSeq) {
            this.writeCSV(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Value[]{value})), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new WriterExecutionException(value.location(), this.getName(), new StringBuilder(73).append("CSV Structure should be either an `Array<Object>` or an `Object` but got ").append(value.valueType(ctx)).toString());
        }
    }

    public void writeHeader(Value<?> value, EvaluationContext ctx) {
        ObjectSeq evaluate = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        BooleanRef first = BooleanRef.create((boolean)true);
        evaluate.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvv -> {
            CSVWriter.$anonfun$writeHeader$1(this, ctx, first, kvv);
            return BoxedUnit.UNIT;
        });
        this.writer().write(this.settings().lineSeparator());
    }

    public void writeCSV(Iterator<Value<?>> iterator, EvaluationContext ctx) {
        boolean first = true;
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (this.settings().header() && first) {
                value = value.materialize(ctx);
                this.writeHeader(value, ctx);
            }
            this.writeRecord(((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx), ctx);
            first = false;
        }
    }

    public void writeEntry(Value<?> value, EvaluationContext ctx) {
        block6: {
            boolean quoteValues;
            char quote = this.settings().quote();
            boolean bl = quoteValues = this.settings().quoteValues() && quote != '\u0000';
            if (quoteValues) {
                this.writer().write(quote);
            }
            if (!NullType$.MODULE$.accepts(value, ctx)) {
                CharSequence stringValue = (CharSequence)StringType$.MODULE$.withSchema(value.schema(ctx)).coerce(value, ctx).evaluate(ctx);
                CharSequence charSequence = stringValue;
                if (charSequence instanceof String) {
                    String string = (String)charSequence;
                    this.writeStringValue(string, quoteValues);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (charSequence instanceof BufferedCharSequence) {
                    BufferedCharSequence bufferedCharSequence = (BufferedCharSequence)charSequence;
                    bufferedCharSequence.foreach((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)chars -> {
                        this.writeStringValue(chars, quoteValues);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.writeStringValue(((Object)stringValue).toString(), quoteValues);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (!quoteValues) break block6;
            this.writer().write(quote);
        }
    }

    private void writeStringValue(String value, boolean quoteValues) {
        if (quoteValues) {
            this.writer().write(this.csvEscape().escapeQuotedString(value));
        } else {
            this.writer().write(this.csvEscape().escapeUnquotedString(value));
        }
    }

    public void writeRecord(Iterator<KeyValuePair> iterator, EvaluationContext ctx) {
        int index = 0;
        while (iterator.hasNext()) {
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            if (index > 0) {
                this.writer().write(this.separator());
            }
            this.writeEntry((Value<?>)kvp._2(), ctx);
            ++index;
        }
        this.writer().write(this.settings().lineSeparator());
    }

    public char separator() {
        return this.settings().separator();
    }

    @Override
    public void close() {
        this.writer().close();
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new CSVDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeHeader$1(CSVWriter $this, EvaluationContext ctx$1, BooleanRef first$1, KeyValuePair kvv) {
        String name = ((QualifiedName)kvv._1().evaluate(ctx$1)).name();
        if (!first$1.elem) {
            $this.writer().write($this.separator());
        }
        if ($this.settings().quoteHeader()) {
            $this.writer().write(new StringBuilder(2).append("\"").append(name).append("\"").toString());
        } else {
            $this.writer().write(name);
        }
        first$1.elem = false;
    }

    public CSVWriter(OutputStream os, CSVWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
    }
}

