/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.core.operator.selectors;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import org.mule.weave.v2.core.exception.ExecutionException;
import org.mule.weave.v2.core.exception.InvalidSelectionException$;
import org.mule.weave.v2.core.exception.KeyNotFoundException;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.QualifiedName;
import scala.Function0;
import scala.Serializable;

public final class DateFieldHelper$ {
    public static DateFieldHelper$ MODULE$;
    private final int HOURS_PER_DAY;
    private final int MINUTES_PER_HOUR;
    private final int MINUTES_PER_DAY;
    private final int SECONDS_PER_MINUTE;
    private final int SECONDS_PER_HOUR;
    private final int SECONDS_PER_DAY;
    private final long MILLIS_PER_DAY;
    private final long MICROS_PER_DAY;
    private final long NANOS_PER_SECOND;
    private final long NANOS_PER_MINUTE;
    private final long NANOS_PER_HOUR;
    private final long NANOS_PER_DAY;

    static {
        new DateFieldHelper$();
    }

    public int HOURS_PER_DAY() {
        return this.HOURS_PER_DAY;
    }

    public int MINUTES_PER_HOUR() {
        return this.MINUTES_PER_HOUR;
    }

    public int MINUTES_PER_DAY() {
        return this.MINUTES_PER_DAY;
    }

    public int SECONDS_PER_MINUTE() {
        return this.SECONDS_PER_MINUTE;
    }

    public int SECONDS_PER_HOUR() {
        return this.SECONDS_PER_HOUR;
    }

    public int SECONDS_PER_DAY() {
        return this.SECONDS_PER_DAY;
    }

    public long MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    public long MICROS_PER_DAY() {
        return this.MICROS_PER_DAY;
    }

    public long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public long NANOS_PER_MINUTE() {
        return this.NANOS_PER_MINUTE;
    }

    public long NANOS_PER_HOUR() {
        return this.NANOS_PER_HOUR;
    }

    public long NANOS_PER_DAY() {
        return this.NANOS_PER_DAY;
    }

    public TemporalField temporalField(QualifiedName name) {
        TemporalField temporalField;
        String string = name.name();
        if ("nanoseconds".equals(string)) {
            temporalField = ChronoField.NANO_OF_SECOND;
        } else if ("milliseconds".equals(string)) {
            temporalField = ChronoField.MILLI_OF_SECOND;
        } else if ("seconds".equals(string)) {
            temporalField = ChronoField.SECOND_OF_MINUTE;
        } else if ("minutes".equals(string)) {
            temporalField = ChronoField.MINUTE_OF_HOUR;
        } else if ("hour".equals(string)) {
            temporalField = ChronoField.HOUR_OF_DAY;
        } else if ("day".equals(string)) {
            temporalField = ChronoField.DAY_OF_MONTH;
        } else if ("month".equals(string)) {
            temporalField = ChronoField.MONTH_OF_YEAR;
        } else if ("year".equals(string)) {
            temporalField = ChronoField.YEAR;
        } else if ("quarter".equals(string)) {
            temporalField = IsoFields.QUARTER_OF_YEAR;
        } else if ("dayOfWeek".equals(string)) {
            temporalField = ChronoField.DAY_OF_WEEK;
        } else if ("dayOfYear".equals(string)) {
            temporalField = ChronoField.DAY_OF_YEAR;
        } else if ("offsetSeconds".equals(string)) {
            temporalField = ChronoField.OFFSET_SECONDS;
        } else {
            throw InvalidSelectionException$.MODULE$.apply((Function0<ExecutionException>)(Function0 & java.io.Serializable & Serializable)() -> new KeyNotFoundException(UnknownLocationCapable$.MODULE$, name));
        }
        return temporalField;
    }

    public TemporalUnit temporalUnit(QualifiedName name) {
        ChronoUnit chronoUnit;
        String string = name.name();
        if ("nanos".equals(string)) {
            chronoUnit = ChronoUnit.NANOS;
        } else if ("micros".equals(string)) {
            chronoUnit = ChronoUnit.MICROS;
        } else if ("milliseconds".equals(string)) {
            chronoUnit = ChronoUnit.MILLIS;
        } else if ("seconds".equals(string)) {
            chronoUnit = ChronoUnit.SECONDS;
        } else if ("minutes".equals(string)) {
            chronoUnit = ChronoUnit.MINUTES;
        } else if ("hours".equals(string)) {
            chronoUnit = ChronoUnit.HOURS;
        } else if ("halfDays".equals(string)) {
            chronoUnit = ChronoUnit.HALF_DAYS;
        } else if ("months".equals(string)) {
            chronoUnit = ChronoUnit.MONTHS;
        } else if ("days".equals(string)) {
            chronoUnit = ChronoUnit.DAYS;
        } else if ("weeks".equals(string)) {
            chronoUnit = ChronoUnit.WEEKS;
        } else if ("years".equals(string)) {
            chronoUnit = ChronoUnit.YEARS;
        } else if ("decades".equals(string)) {
            chronoUnit = ChronoUnit.DECADES;
        } else if ("centuries".equals(string)) {
            chronoUnit = ChronoUnit.CENTURIES;
        } else if ("millennia".equals(string)) {
            chronoUnit = ChronoUnit.MILLENNIA;
        } else if ("eras".equals(string)) {
            chronoUnit = ChronoUnit.ERAS;
        } else if ("forever".equals(string)) {
            chronoUnit = ChronoUnit.FOREVER;
        } else {
            throw InvalidSelectionException$.MODULE$.apply((Function0<ExecutionException>)(Function0 & java.io.Serializable & Serializable)() -> new KeyNotFoundException(UnknownLocationCapable$.MODULE$, name));
        }
        return chronoUnit;
    }

    private DateFieldHelper$() {
        MODULE$ = this;
        this.HOURS_PER_DAY = 24;
        this.MINUTES_PER_HOUR = 60;
        this.MINUTES_PER_DAY = this.MINUTES_PER_HOUR() * this.HOURS_PER_DAY();
        this.SECONDS_PER_MINUTE = 60;
        this.SECONDS_PER_HOUR = this.SECONDS_PER_MINUTE() * this.MINUTES_PER_HOUR();
        this.SECONDS_PER_DAY = this.SECONDS_PER_HOUR() * this.HOURS_PER_DAY();
        this.MILLIS_PER_DAY = (long)this.SECONDS_PER_DAY() * 1000L;
        this.MICROS_PER_DAY = (long)this.SECONDS_PER_DAY() * 1000000L;
        this.NANOS_PER_SECOND = 1000000000L;
        this.NANOS_PER_MINUTE = this.NANOS_PER_SECOND() * (long)this.SECONDS_PER_MINUTE();
        this.NANOS_PER_HOUR = this.NANOS_PER_MINUTE() * (long)this.MINUTES_PER_HOUR();
        this.NANOS_PER_DAY = this.NANOS_PER_HOUR() * (long)this.HOURS_PER_DAY();
    }
}

