/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.mule.weave.v2.core.RuntimeConfigProperties$;
import org.mule.weave.v2.core.versioning.CompatibilityFlag;
import org.mule.weave.v2.core.versioning.Setting;
import org.mule.weave.v2.core.versioning.SystemSetting;
import org.mule.weave.v2.model.service.DWSettings;
import org.mule.weave.v2.model.service.DefaultSettingsService$;
import org.mule.weave.v2.utils.DataWeaveVersion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class SystemPropertiesDocGenerator$ {
    public static SystemPropertiesDocGenerator$ MODULE$;

    static {
        new SystemPropertiesDocGenerator$();
    }

    public void main(String[] args) {
        if (args.length == 0) {
            Predef$.MODULE$.println((Object)"Missing target directory param or DW version");
            return;
        }
        String folder = args[0];
        File targetFolder = new File(folder);
        if (targetFolder.isFile()) {
            Predef$.MODULE$.println((Object)"Target should be a directory");
            return;
        }
        targetFolder.mkdirs();
        Seq<DWSettings> settings = DefaultSettingsService$.MODULE$.settings();
        Seq systemSettings = (Seq)((TraversableLike)settings.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.settings(), Seq$.MODULE$.canBuildFrom())).$plus$plus(RuntimeConfigProperties$.MODULE$.runtimeConfigProperties(), Seq$.MODULE$.canBuildFrom());
        File targetFile = new File(targetFolder, "dataweave-system-properties.adoc");
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("Creating documentation for system properties at ").append(targetFile.getAbsolutePath()).toString());
        String docHeader = new StringOps(Predef$.MODULE$.augmentString("|= DataWeave System Properties\n                       |\n                       |DataWeave supports several system properties. To use these properties in application development and deployments, see xref:mule-runtime:mule-app-properties-system.adoc[System Properties].\n                       |\n                       |[%header%autowidth.spread,cols=\",a\"]\n                       ||===\n                       ||Property |Description\n")).stripMargin();
        String docEnding = "|===";
        Seq entries = (Seq)((TraversableLike)((SeqLike)systemSettings.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SystemPropertiesDocGenerator$.$anonfun$main$2(x$2)))).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.fullName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)setting -> MODULE$.generateEntry((Setting<?>)setting), Seq$.MODULE$.canBuildFrom());
        String content = ((TraversableOnce)new .colon.colon((Object)docHeader, (List)new .colon.colon((Object)entries.mkString("\n"), (List)new .colon.colon((Object)docEnding, (List)Nil$.MODULE$)))).mkString("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));){
            writer.write(content);
        }
    }

    private String generateEntry(Setting<?> setting) {
        String string;
        Setting<?> setting2 = setting;
        if (setting2 instanceof CompatibilityFlag) {
            CompatibilityFlag compatibilityFlag = (CompatibilityFlag)setting2;
            string = this.generateCompatibilityFlagEntry(compatibilityFlag);
        } else if (setting2 instanceof SystemSetting) {
            SystemSetting systemSetting = (SystemSetting)setting2;
            string = this.generateSystemSettingEntry(systemSetting);
        } else {
            string = "";
        }
        return string;
    }

    private String generateSystemSettingEntry(SystemSetting<?> systemSetting) {
        String description = systemSetting.experimental() ? new StringBuilder(18).append("_Experimental:_ ").append(systemSetting.description()).append(" \n").toString() : systemSetting.description();
        String experimentalDisclaimer = systemSetting.experimental() ? new StringBuilder(144).append("`\n").append(systemSetting.fullName()).append("` is an _experimental feature_ that is subject to change or removal from future versions of DataWeave. See xref:dataweave-troubleshoot.adoc[].").toString() : "";
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("|//").append(systemSetting.fullName()).append("//\n       ||`").append(systemSetting.fullName()).append("`|\n       |").append(description).append("\n\n       |* Type: `").append(new StringOps(Predef$.MODULE$.augmentString(systemSetting.defaultValue().getClass().getSimpleName())).capitalize()).append("`\n       |* Default: `").append(systemSetting.defaultValueDisplay().getOrElse((Function0 & Serializable & scala.Serializable)() -> systemSetting.defaultValue())).append("`\n       |").append(experimentalDisclaimer).append("\n").toString())).stripMargin();
    }

    private String generateCompatibilityFlagEntry(CompatibilityFlag cf) {
        String llRange = this.generateLanguageLevelRange(cf);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("|//").append(cf.fullName()).append("//\n        ||`").append(cf.fullName()).append("`|\n\n        |").append(cf.description()).append("\n\n        |* Type: `").append(new StringOps(Predef$.MODULE$.augmentString(ScalaRunTime$.MODULE$.anyValClass((Object)BoxesRunTime.boxToBoolean((boolean)cf.defaultValue()), ClassTag$.MODULE$.Boolean()).getSimpleName())).capitalize()).append("`\n\n        |* Default: `").append(this.generateDefaultValues(cf)).append("`\n\n        |Available for language levels: ").append(llRange).append("\n\n").toString())).stripMargin();
    }

    private String generateLanguageLevelRange(CompatibilityFlag cf) {
        DataWeaveVersion currentVersion = cf.creationVersion();
        Seq range = (Seq)Nil$.MODULE$;
        while (currentVersion.$less(cf.deletionVersion())) {
            range = (Seq)range.$colon$plus((Object)currentVersion, Seq$.MODULE$.canBuildFrom());
            currentVersion = new DataWeaveVersion(currentVersion.major(), currentVersion.minor() + 1);
        }
        return ((TraversableOnce)range.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String generateDefaultValues(CompatibilityFlag cf) {
        DataWeaveVersion dataWeaveVersion = cf.behaviorChangeVersion();
        DataWeaveVersion dataWeaveVersion2 = cf.deletionVersion();
        if (!(dataWeaveVersion != null ? !((Object)dataWeaveVersion).equals(dataWeaveVersion2) : dataWeaveVersion2 != null)) {
            return Boolean.toString(cf.initialValue());
        }
        Seq initialValueRange = (Seq)Nil$.MODULE$;
        Seq newBehaviorValueRange = (Seq)Nil$.MODULE$;
        DataWeaveVersion currentVersion = cf.creationVersion();
        while (currentVersion.$less(cf.deletionVersion())) {
            if (currentVersion.$less(cf.behaviorChangeVersion())) {
                initialValueRange = (Seq)initialValueRange.$colon$plus((Object)currentVersion, Seq$.MODULE$.canBuildFrom());
            } else {
                newBehaviorValueRange = (Seq)newBehaviorValueRange.$colon$plus((Object)currentVersion, Seq$.MODULE$.canBuildFrom());
            }
            currentVersion = new DataWeaveVersion(currentVersion.major(), currentVersion.minor() + 1);
        }
        String initialValueStr = ((TraversableOnce)initialValueRange.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String newBehaviorValueStr = ((TraversableOnce)newBehaviorValueRange.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n       |  ").append(cf.defaultValueDisplay().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> cf.initialValue())).append(" for language levels: ").append(initialValueStr).append("\n\n       |  ").append(cf.defaultValueDisplay().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> cf.newBehaviorValue())).append(" for language levels: ").append(newBehaviorValueStr).toString())).stripMargin();
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Setting x$2) {
        return !x$2.internal();
    }

    private SystemPropertiesDocGenerator$() {
        MODULE$ = this;
    }
}

