/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.IgnoreOnLazyInit;

@IgnoreOnLazyInit
public class ScatterGatherRoutes
implements Validation {
    private static final String SCATTER_GATHER_ELEMENT = "scatter-gather";
    private static final ComponentIdentifier SCATTER_GATHER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("scatter-gather").build();

    @Override
    public String getName() {
        return "'scatter-gather' has at least 2 routes";
    }

    @Override
    public String getDescription() {
        return "'scatter-gather' has at least 2 routes";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(SCATTER_GATHER_IDENTIFIER));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.directChildrenStream().filter(c -> c.getIdentifier().getName().equals("route")).count() < 2L) {
            return Optional.of(ValidationResultItem.create(component, (Validation)this, "At least 2 routes are required for 'scatter-gather'."));
        }
        return Optional.empty();
    }
}

