/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;

public final class ExtensionModelLoadingRequest {
    private final ClassLoader extensionClassLoader;
    private final DslResolvingContext dslResolvingContext;
    private final List<ExtensionModelValidator> validators = new LinkedList<ExtensionModelValidator>();
    private final List<DeclarationEnricher> enrichers = new LinkedList<DeclarationEnricher>();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private ArtifactCoordinates artifactCoordinates;
    private boolean ocsEnabled;

    public static Builder builder(ClassLoader extensionClassLoader, DslResolvingContext dslResolvingContext) {
        return new Builder(extensionClassLoader, dslResolvingContext);
    }

    private ExtensionModelLoadingRequest(ClassLoader extensionClassLoader, DslResolvingContext dslResolvingContext) {
        Preconditions.checkArgument(extensionClassLoader != null, "extension classLoader cannot be null");
        Preconditions.checkArgument(dslResolvingContext != null, "Dsl resolving context cannot be null");
        this.extensionClassLoader = extensionClassLoader;
        this.dslResolvingContext = dslResolvingContext;
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    public DslResolvingContext getDslResolvingContext() {
        return this.dslResolvingContext;
    }

    public boolean isOCSEnabled() {
        return this.ocsEnabled;
    }

    public List<ExtensionModelValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<DeclarationEnricher> getEnrichers() {
        return Collections.unmodifiableList(this.enrichers);
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public static final class Builder {
        private final ExtensionModelLoadingRequest product;

        private Builder(ClassLoader extensionClassLoader, DslResolvingContext dslResolvingContext) {
            this.product = new ExtensionModelLoadingRequest(extensionClassLoader, dslResolvingContext);
        }

        public Builder addParameter(String key, Object value) {
            Preconditions.checkArgument(key != null && key.length() > 0, "key cannot be blank");
            Preconditions.checkArgument(value != null, "value cannot be null");
            this.product.parameters.put(key, value);
            return this;
        }

        public Builder addParameters(Map<String, Object> parameters) {
            parameters.forEach((k, v) -> this.addParameter((String)k, v));
            return this;
        }

        public Builder addValidator(ExtensionModelValidator validator) {
            Preconditions.checkArgument(validator != null, "validator cannot be null");
            this.product.validators.add(validator);
            return this;
        }

        public Builder addEnricher(DeclarationEnricher enricher) {
            Preconditions.checkArgument(enricher != null, "enricher cannot be null");
            this.product.enrichers.add(enricher);
            return this;
        }

        public Builder setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
            Preconditions.checkArgument(artifactCoordinates != null, "artifactCoordinates cannot be null");
            this.product.artifactCoordinates = artifactCoordinates;
            return this;
        }

        public Builder setOCSEnabled(boolean ocsEnabled) {
            this.product.ocsEnabled = ocsEnabled;
            return this;
        }

        public ExtensionModelLoadingRequest build() {
            return this.product;
        }
    }
}

