/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolutionException;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class ApplicationDescriptorFactory
extends AbstractDeployableArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> {
    private final DomainDescriptorResolver domainDescriptorResolver;
    private final DeployableArtifactDescriptorCreator<ApplicationDescriptor> descriptorCreator;

    public ApplicationDescriptorFactory(DeployableProjectModel deployableProjectModel, Map<String, String> deploymentProperties, PluginModelResolver pluginModelResolver, PluginDescriptorResolver pluginDescriptorResolver, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder, DomainDescriptorResolver domainDescriptorResolver, DeployableArtifactDescriptorCreator<ApplicationDescriptor> descriptorCreator) {
        super(deployableProjectModel, deploymentProperties, pluginModelResolver, pluginDescriptorResolver, artifactDescriptorValidatorBuilder);
        this.domainDescriptorResolver = domainDescriptorResolver;
        this.descriptorCreator = descriptorCreator;
    }

    @Override
    protected MuleApplicationModel createArtifactModel() {
        return (MuleApplicationModel)this.getDeployableModel();
    }

    @Override
    protected void doValidation(ApplicationDescriptor descriptor) {
        super.doValidation(descriptor);
        Set<ArtifactPluginDescriptor> domainPlugins = this.getApplicationDomainDescriptor(descriptor).map(DeployableArtifactDescriptor::getPlugins).orElse(Collections.emptySet());
        List<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = this.getPluginDependenciesResolver().resolve(domainPlugins, new ArrayList<ArtifactPluginDescriptor>(descriptor.getPlugins()), true);
        descriptor.setPlugins(new LinkedHashSet<ArtifactPluginDescriptor>(resolvedArtifactPluginDescriptors));
    }

    private Optional<DomainDescriptor> getApplicationDomainDescriptor(ApplicationDescriptor descriptor) {
        Optional<DomainDescriptor> resolvedDomainDescriptor = this.resolveApplicationDomain(descriptor);
        descriptor.setDomainName(resolvedDomainDescriptor.map(ArtifactDescriptor::getName).orElse("default"));
        return resolvedDomainDescriptor;
    }

    private Optional<DomainDescriptor> resolveApplicationDomain(ApplicationDescriptor descriptor) {
        boolean shouldUseDefaultDomain;
        String configuredDomainName = descriptor.getDomainName();
        Optional<BundleDescriptor> domainBundleDescriptor = descriptor.getDomainDescriptor();
        boolean bl = shouldUseDefaultDomain = configuredDomainName == null || "default".equals(configuredDomainName);
        if (!shouldUseDefaultDomain && !domainBundleDescriptor.isPresent()) {
            throw new IllegalStateException(String.format("Dependency for domain '%s' was not declared", configuredDomainName));
        }
        if (!domainBundleDescriptor.isPresent()) {
            return Optional.empty();
        }
        if (this.domainDescriptorResolver == null) {
            throw new IllegalStateException(String.format("Application depends on domain '%s', a domain descriptor resolver must be provided", configuredDomainName));
        }
        DomainDescriptor domainDescriptor = this.domainDescriptorResolver.resolve(configuredDomainName, domainBundleDescriptor.get());
        if (domainDescriptor == null) {
            throw new IllegalStateException(String.format("Domain '%s' couldn't be fetched", configuredDomainName != null ? configuredDomainName : domainBundleDescriptor.get().getArtifactId()));
        }
        if (!ApplicationDescriptorFactory.isCompatibleBundle(domainDescriptor.getBundleDescriptor(), domainBundleDescriptor.get())) {
            throw new DomainDescriptorResolutionException(I18nMessageFactory.createStaticMessage("A domain with name '%s' was found, but its bundle descriptor is not compatible with the application declared dependency. The found domain bundle descriptor is '%s'", configuredDomainName, domainDescriptor.getBundleDescriptor()));
        }
        return Optional.of(domainDescriptor);
    }

    private static boolean isCompatibleBundle(BundleDescriptor available, BundleDescriptor expected) {
        if (!available.getClassifier().equals(expected.getClassifier())) {
            return false;
        }
        if (!available.getGroupId().equals(expected.getGroupId())) {
            return false;
        }
        if (!available.getArtifactId().equals(expected.getArtifactId())) {
            return false;
        }
        return BundleDescriptorUtils.isCompatibleVersion(available.getVersion(), expected.getVersion());
    }

    @Override
    protected void doDescriptorConfig(ApplicationDescriptor descriptor) {
        super.doDescriptorConfig(descriptor);
        ((MuleApplicationModel)this.getArtifactModel()).getDomain().ifPresent(descriptor::setDomainName);
    }

    @Override
    protected String getDefaultConfigurationResource() {
        return "mule-config.xml";
    }

    @Override
    protected ApplicationDescriptor doCreateArtifactDescriptor() {
        return this.descriptorCreator.create(this.getArtifactLocation().getName(), this.getDeploymentProperties());
    }
}

