/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactStartedSplashScreen;

public class ApplicationStartedSplashScreen
extends ArtifactStartedSplashScreen<ApplicationDescriptor> {
    private static final String PLUGIN_VALUE_FORMAT = " - %s (%s)";

    @Override
    public void createMessage(ApplicationDescriptor descriptor) {
        this.doBody(String.format("Started app '%s'", descriptor.getName()));
        if (RUNTIME_VERBOSE_PROPERTY.isEnabled()) {
            this.listPlugins("Application", descriptor);
            this.listLibraries(descriptor);
        }
    }

    private void listPlugins(ApplicationDescriptor descriptor) {
        Set<ArtifactPluginDescriptor> plugins = descriptor.getPlugins();
        if (!plugins.isEmpty()) {
            this.doBody("Application plugins:");
            for (ArtifactPluginDescriptor plugin : plugins) {
                this.doBody(String.format(PLUGIN_VALUE_FORMAT, plugin.getName(), plugin.getBundleDescriptor().getArtifactFileName()));
            }
        }
    }

    protected void listLibraries(ApplicationDescriptor descriptor) {
        URL[] urls = descriptor.getClassLoaderConfiguration().getUrls();
        urls = Arrays.copyOfRange(urls, 1, urls.length);
        this.listItems(Arrays.stream(urls).map(url -> FileUtils.toFile((URL)url).getName()).collect(Collectors.toList()), "Application libraries:");
    }
}

