/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.source;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.client.source.SourceCallbackParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.client.source.DefaultSourceCallbackParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.source.SourceClient;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionsFlowProcessingTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSourceResultHandler<T, A>
implements SourceResultHandler<T, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSourceResultHandler.class);
    private final SourceClient sourceClient;
    private final Result<T, A> result;
    private final ExtensionsFlowProcessingTemplate template;
    private final ClassLoader extensionClassLoader;

    DefaultSourceResultHandler(SourceClient sourceClient, Result<T, A> result, ExtensionsFlowProcessingTemplate template) {
        this.sourceClient = sourceClient;
        this.result = result;
        this.template = template;
        this.extensionClassLoader = sourceClient.getExtensionClassLoader();
    }

    @Override
    public Result<T, A> getResult() {
        return this.result;
    }

    private void afterPhaseExecution(Either<MessagingException, CoreEvent> either, ClassLoader extensionClassLoader) {
        ClassUtils.withContextClassLoader(extensionClassLoader, () -> this.template.afterPhaseExecution(either));
    }

    @Override
    public CompletableFuture<Void> completeWithSuccess(Consumer<SourceCallbackParameterizer> successCallbackParameters) {
        return FunctionalUtils.withNullEvent(event -> {
            CompletableFuture future = new CompletableFuture();
            future.whenComplete((v, t) -> {
                if (t != null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Failed to send success response to client: " + t.getMessage(), t);
                    }
                    this.afterPhaseExecution(Either.left(this.sourceClient.asMessagingException((Throwable)t, (CoreEvent)event)), this.extensionClassLoader);
                } else {
                    this.afterPhaseExecution(Either.right(event), this.extensionClassLoader);
                }
            });
            try {
                Map<String, Object> params = this.resolveCallbackParameters((Optional<? extends ParameterizedModel>)this.sourceClient.getSourceModel().getSuccessCallback(), successCallbackParameters, (CoreEvent)event);
                ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> this.template.sendResponseToClient((CoreEvent)event, params, new FutureCompletionCallback(future)));
            }
            catch (Throwable t2) {
                future.completeExceptionally(t2);
            }
            return future;
        });
    }

    @Override
    public CompletableFuture<Void> completeWithError(Throwable exception, Consumer<SourceCallbackParameterizer> errorCallbackParameters) {
        ClassLoader extensionClassLoader = this.sourceClient.getExtensionClassLoader();
        return FunctionalUtils.withNullEvent(event -> {
            MessagingException messagingException = this.sourceClient.asMessagingException(exception, (CoreEvent)event);
            CompletableFuture future = new CompletableFuture();
            future.whenComplete((v, t) -> {
                if (t != null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Failed to send error response to client: " + t.getMessage(), t);
                    }
                    this.afterPhaseExecution(Either.left(this.sourceClient.asMessagingException((Throwable)t, (CoreEvent)event)), extensionClassLoader);
                } else {
                    this.afterPhaseExecution(Either.left(messagingException), extensionClassLoader);
                }
            });
            try {
                Map<String, Object> params = this.resolveCallbackParameters(this.sourceClient.getSourceModel().getErrorCallback(), errorCallbackParameters, messagingException.getEvent());
                ClassUtils.withContextClassLoader(extensionClassLoader, () -> this.template.sendFailureResponseToClient(messagingException, params, new FutureCompletionCallback(future)));
            }
            catch (Throwable t2) {
                future.completeExceptionally(t2);
            }
            return future;
        });
    }

    private Map<String, Object> resolveCallbackParameters(Optional<? extends ParameterizedModel> callbackModel, Consumer<SourceCallbackParameterizer> parameterizerConsumer, CoreEvent event) {
        DefaultSourceCallbackParameterizer parameterizer = new DefaultSourceCallbackParameterizer();
        parameterizerConsumer.accept(parameterizer);
        return callbackModel.map(model -> ResolverSetUtils.evaluate(this.sourceClient.toResolverSet(parameterizer, (ParameterizedModel)model), this.sourceClient.resolveConfigurationInstance(event), event)).orElse(Collections.emptyMap());
    }

    private class FutureCompletionCallback
    implements CompletableCallback<Void> {
        private final CompletableFuture<Void> future;

        private FutureCompletionCallback(CompletableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void complete(Void value) {
            this.future.complete(value);
        }

        @Override
        public void error(Throwable e) {
            this.future.completeExceptionally(e);
        }
    }
}

