/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderDecorator;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProvider;

public abstract class IdentifiableCursorProviderDecorator<T extends Cursor>
extends CursorProviderDecorator<T>
implements IdentifiableCursorProvider<T> {
    private static final transient AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private final int id;

    public static <T extends Cursor> IdentifiableCursorProviderDecorator<T> of(CursorProvider<T> cursorProvider) {
        CursorProvider<T> root = cursorProvider;
        if (cursorProvider instanceof IdentifiableCursorProviderDecorator) {
            return (IdentifiableCursorProviderDecorator)cursorProvider;
        }
        Integer id = null;
        do {
            if (cursorProvider instanceof IdentifiableCursorProvider) {
                id = ((IdentifiableCursorProvider)cursorProvider).getId();
                break;
            }
            if (!(cursorProvider instanceof CursorProviderDecorator)) continue;
            cursorProvider = ((CursorProviderDecorator)cursorProvider).getDelegate();
        } while (cursorProvider instanceof CursorProviderDecorator);
        if (id == null) {
            id = ID_GENERATOR.incrementAndGet();
        }
        if (cursorProvider instanceof CursorStreamProvider) {
            return new IdentifiableCursorStreamProviderDecorator((CursorStreamProvider)root, (int)id);
        }
        return new IdentifiableCursorIteratorProviderDecorator((CursorIteratorProvider)root, (int)id);
    }

    private IdentifiableCursorProviderDecorator(CursorProvider<T> delegate, int id) {
        super(delegate);
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    private static class IdentifiableCursorIteratorProviderDecorator
    extends IdentifiableCursorProviderDecorator<CursorIterator>
    implements CursorIteratorProvider {
        public IdentifiableCursorIteratorProviderDecorator(CursorIteratorProvider delegate, int id) {
            super(delegate, id);
        }
    }

    private static class IdentifiableCursorStreamProviderDecorator
    extends IdentifiableCursorProviderDecorator<CursorStream>
    implements CursorStreamProvider {
        public IdentifiableCursorStreamProviderDecorator(CursorStreamProvider delegate, int id) {
            super(delegate, id);
        }
    }
}

