/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionalConnectionHandler<T extends TransactionalConnection>
implements ConnectionHandlerAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalConnectionHandler.class);
    private final ExtensionTransactionalResource<T> resource;
    private final ConnectionHandlerAdapter<T> connectionHandler;

    public TransactionalConnectionHandler(ExtensionTransactionalResource<T> resource) {
        Preconditions.checkArgument(resource != null, "resource cannot be null");
        this.resource = resource;
        ConnectionHandler<T> connectionHandler = resource.getConnectionHandler();
        Preconditions.checkArgument(connectionHandler instanceof ConnectionHandlerAdapter, "connectionHandlerAdapter was expected");
        this.connectionHandler = (ConnectionHandlerAdapter)connectionHandler;
    }

    @Override
    public T getConnection() throws ConnectionException {
        return this.resource.getConnection();
    }

    @Override
    public void release() {
    }

    @Override
    public void invalidate() {
        try {
            this.forceRollback();
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Failed to rollback transaction while invalidating connection %s. %s", e, e.getMessage()), (Throwable)e);
            }
        }
        finally {
            this.connectionHandler.invalidate();
        }
    }

    @Override
    public void close() throws MuleException {
        try {
            this.forceRollback();
        }
        finally {
            this.connectionHandler.close();
        }
    }

    @Override
    public ConnectionProvider<T> getConnectionProvider() {
        return this.connectionHandler.getConnectionProvider();
    }

    private void forceRollback() throws TransactionException {
        try {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }
}

