/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanDuration;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.impl.clock.Clock;
import org.mule.runtime.tracer.impl.span.InternalSpan;

public class ExportOnEndExecutionSpan
implements InternalSpan {
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";
    private final InitialSpanInfo initialSpanInfo;
    private final SpanExporter spanExporter;
    private SpanError lastError;
    private final InternalSpan parent;
    private final Long startTime;
    private Long endTime;
    private final Map<String, String> additionalAttributes = new HashMap<String, String>();

    private ExportOnEndExecutionSpan(SpanExporterFactory spanExporterFactory, InitialSpanInfo initialSpanInfo, Long startTime, InternalSpan parent) {
        this.initialSpanInfo = initialSpanInfo;
        this.startTime = startTime;
        this.parent = parent;
        this.spanExporter = spanExporterFactory.getSpanExporter(this, initialSpanInfo);
    }

    public static InternalSpan createExportOnEndExecutionSpan(SpanExporterFactory spanExporterFactory, InternalSpan parentSpan, InitialSpanInfo initialSpanInfo) {
        Objects.requireNonNull(spanExporterFactory);
        Objects.requireNonNull(initialSpanInfo);
        ExportOnEndExecutionSpan exportOnEndExecutionSpan = new ExportOnEndExecutionSpan(spanExporterFactory, initialSpanInfo, Clock.getDefault().now(), parentSpan);
        return parentSpan.onChild(exportOnEndExecutionSpan);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    @Override
    public InternalSpan onChild(InternalSpan child) {
        if (child instanceof ExportOnEndExecutionSpan) {
            this.spanExporter.updateChildSpanExporter(((ExportOnEndExecutionSpan)child).getSpanExporter());
        }
        return child;
    }

    @Override
    public void updateRootName(String name) {
        this.spanExporter.setRootName(name);
    }

    @Override
    public void end() {
        this.end(Clock.getDefault().now());
    }

    @Override
    public void end(long endTime) {
        this.endTime = endTime;
        this.spanExporter.export();
    }

    @Override
    public void addError(InternalSpanError error) {
        this.lastError = error;
        this.spanExporter.onError(error);
    }

    @Override
    public void updateName(String name) {
        this.spanExporter.updateNameForExport(name);
    }

    @Override
    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.initialSpanInfo.forEachAttribute(biConsumer);
        if (!this.additionalAttributes.isEmpty()) {
            this.additionalAttributes.forEach(biConsumer);
        }
    }

    @Override
    public Map<String, String> serializeAsMap() {
        return this.spanExporter.exportedSpanAsMap();
    }

    @Override
    public boolean hasErrors() {
        return this.lastError != null;
    }

    @Override
    public Span getParent() {
        return this.parent;
    }

    @Override
    public SpanIdentifier getIdentifier() {
        return this.getSpanExporter().getSpanIdentifier();
    }

    @Override
    public String getName() {
        return this.initialSpanInfo.getName();
    }

    @Override
    public SpanDuration getDuration() {
        return new DefaultSpanDuration(this.startTime, this.endTime);
    }

    @Override
    public List<SpanError> getErrors() {
        if (this.lastError != null) {
            return Collections.singletonList(this.lastError);
        }
        return Collections.emptyList();
    }

    @Override
    public int getAttributesCount() {
        return this.initialSpanInfo.getInitialAttributesCount() + this.additionalAttributes.size();
    }

    @Override
    public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
        this.spanExporter.setRootAttribute(rootAttributeKey, rootAttributeValue);
    }

    @Override
    public void addAttribute(String key, String value) {
        if (!(key.equals(SPAN_KIND) || key.equals(STATUS) || this.initialSpanInfo.isPolicySpan())) {
            this.additionalAttributes.put(key, value);
        }
        this.spanExporter.onAdditionalAttribute(key, value);
    }

    private static class DefaultSpanDuration
    implements SpanDuration {
        private final Long startTime;
        private final Long endTime;

        public DefaultSpanDuration(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Override
        public Long getStart() {
            return this.startTime;
        }

        @Override
        public Long getEnd() {
            return this.endTime;
        }
    }
}

