/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.api.map;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.raml.internal.CustomHandlingTypeDeclarationTypeLoader;
import org.mule.metadata.raml.internal.RamlTypeLoader;

public class MapTypeLoader
implements TypeLoader {
    private static final List<Class<? extends MetadataType>> VALID_FIELD_TYPES = Arrays.asList(StringType.class, NumberType.class, BooleanType.class, DateType.class, DateTimeType.class);
    private final RamlTypeLoader ramlTypeLoader;

    public MapTypeLoader(File ramlFile) {
        this.ramlTypeLoader = new RamlTypeLoader(ramlFile, new CustomHandlingTypeDeclarationTypeLoader(MetadataFormat.JAVA));
    }

    public MapTypeLoader(String content, String ramlLocation) {
        this.ramlTypeLoader = new RamlTypeLoader(content, ramlLocation, new CustomHandlingTypeDeclarationTypeLoader(MetadataFormat.JAVA));
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.ramlTypeLoader.load(typeIdentifier, typeAlias).map(metadataType -> {
            this.validate((MetadataType)metadataType);
            return metadataType;
        });
    }

    private boolean validArrayType(MetadataType metadataType) {
        if (!(metadataType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)metadataType;
        MetadataType elementType = arrayType.getType();
        return this.validSimpleType(elementType) || this.validObjectType(elementType);
    }

    private boolean validObjectType(MetadataType metadataType) {
        if (!(metadataType instanceof ObjectType)) {
            return false;
        }
        ObjectType objectType = (ObjectType)metadataType;
        for (ObjectFieldType objectFieldType : objectType.getFields()) {
            if (this.validSimpleType(objectFieldType) || this.validObjectType(objectFieldType) || this.validArrayType(objectFieldType)) continue;
            return false;
        }
        return true;
    }

    private boolean validSimpleType(MetadataType metadataType) {
        for (Class<? extends MetadataType> validSimpleTypeClass : VALID_FIELD_TYPES) {
            if (!validSimpleTypeClass.isAssignableFrom(metadataType.getClass())) continue;
            return true;
        }
        return false;
    }

    private void validate(MetadataType metadataType) {
        if (this.validArrayType(metadataType) || this.validObjectType(metadataType)) {
            throw new RuntimeException("Invalid RAML type for Map format.");
        }
    }
}

