/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.util.ExtensionConnectivityUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.streaming.CursorResetInterceptor;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ReconnectionUtils {
    public static Consumer<Throwable> NULL_THROWABLE_CONSUMER = e -> {};

    public static boolean shouldRetry(Throwable t, ExecutionContextAdapter<?> context) {
        Optional<String> contextConfigName = context.getConfiguration().map(ConfigurationInstance::getName);
        Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(t);
        if (!connectionException.isPresent() || Boolean.valueOf((String)context.getVariable("MULE_DO_NOT_RETRY")).booleanValue()) {
            return false;
        }
        if (ReconnectionUtils.isPartOfActiveTransaction(context.getConfiguration().get()) || ExceptionUtils.extractCauseOfType(t, TransactionException.class).isPresent()) {
            return false;
        }
        return ReconnectionUtils.isConnectionExceptionFromCurrentComponent(connectionException.get(), contextConfigName.orElse(null));
    }

    private static boolean isConnectionExceptionFromCurrentComponent(ConnectionException connectionException, String contextConfigName) {
        Boolean isTransactional = (Boolean)connectionException.getInfo().get("MULE_IS_TRANSACTIONAL");
        if (isTransactional != null && isTransactional.booleanValue()) {
            return false;
        }
        Object operationConfigName = connectionException.getInfo().get("MULE_COMPONENT_CONFIG_NAME");
        if (operationConfigName != null && contextConfigName != null) {
            return contextConfigName.equals(operationConfigName);
        }
        return true;
    }

    public static boolean isPartOfActiveTransaction(ConfigurationInstance configurationInstance) {
        if (TransactionCoordination.isTransactionActive()) {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            return tx != null && tx.hasResource(new ExtensionTransactionKey(configurationInstance));
        }
        return false;
    }

    public static InterceptorChain.Builder addCursorResetInterceptorsIfRequired(InterceptorChain.Builder chainBuilder, ExtensionModel extensionModel, ComponentModel componentModel, ReflectionCache reflectionCache) {
        if (ReconnectionUtils.requiresCursorResetInterceptors(componentModel)) {
            ReconnectionUtils.addCursorResetInterceptor(chainBuilder, extensionModel, componentModel, reflectionCache);
        }
        return chainBuilder;
    }

    private static boolean requiresCursorResetInterceptors(ComponentModel componentModel) {
        if (componentModel instanceof ConnectableComponentModel) {
            return ((ConnectableComponentModel)componentModel).requiresConnection() && ExtensionConnectivityUtils.isReconnectionStrategySupported((ConnectableComponentModel)componentModel);
        }
        return false;
    }

    private static void addCursorResetInterceptor(InterceptorChain.Builder chainBuilder, ExtensionModel extensionModel, ComponentModel componentModel, ReflectionCache reflectionCache) {
        Map<ParameterGroupModel, Set<ParameterModel>> streamParameters = IntrospectionUtils.getFilteredParameters(componentModel, ReconnectionUtils.getStreamParameterFilter(extensionModel));
        if (!streamParameters.isEmpty()) {
            chainBuilder.addInterceptor(new CursorResetInterceptor(streamParameters, reflectionCache));
        }
    }

    private static Predicate<ParameterModel> getStreamParameterFilter(ExtensionModel extensionModel) {
        ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        return p -> ExtensionMetadataTypeUtils.getType(p.getType(), extensionClassLoader).filter(clazz -> InputStream.class.isAssignableFrom((Class<?>)clazz) || Iterator.class.isAssignableFrom((Class<?>)clazz)).isPresent();
    }
}

