/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.mule.runtime.core.internal.connection.PoolingConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolingConnectionManagementStrategy<C>
extends ConnectionManagementStrategy<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingConnectionManagementStrategy.class);
    private final PoolingProfile poolingProfile;
    private final GenericObjectPool<C> pool;
    private final String poolId;
    private final PoolingListener<C> poolingListener;

    PoolingConnectionManagementStrategy(ConnectionProvider<C> connectionProvider, PoolingProfile poolingProfile, PoolingListener<C> poolingListener, MuleContext muleContext, String ownerConfigName, FeatureFlaggingService featureFlaggingService) {
        super(connectionProvider, muleContext);
        this.poolingProfile = poolingProfile;
        this.poolingListener = poolingListener;
        this.poolId = ownerConfigName.concat("-").concat(this.generateId());
        this.pool = this.createPool(ownerConfigName, featureFlaggingService);
    }

    @Override
    public ConnectionHandler<C> getConnectionHandler() throws ConnectionException {
        try {
            return new PoolingConnectionHandler<C>(this.borrowConnection(), this.pool, this.poolId, this.poolingListener, this.connectionProvider);
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new ConnectionException("Connection pool is exhausted", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConnectionException("An exception was found trying to obtain a connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private C borrowConnection() throws Exception {
        Object connection = this.pool.borrowObject();
        LOGGER.debug("Acquiring connection {} from the pool {}", (Object)connection.toString(), (Object)this.poolId);
        ConnectionUtils.logPoolStatus(LOGGER, this.pool, this.poolId);
        try {
            this.poolingListener.onBorrow(connection);
        }
        catch (Exception e) {
            this.pool.invalidateObject(connection);
            throw e;
        }
        return (C)connection;
    }

    @Override
    public void close() throws MuleException {
        try {
            ConnectionUtils.logPoolStatus(LOGGER, this.pool, this.poolId);
            LOGGER.debug("Closing pool {}", (Object)this.poolId);
            this.pool.close();
        }
        catch (Exception e) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage("Could not close connection pool"), (Throwable)e);
        }
    }

    private GenericObjectPool<C> createPool(String ownerConfigName, FeatureFlaggingService featureFlaggingService) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(this.poolingProfile.getMaxIdle());
        if (featureFlaggingService != null && featureFlaggingService.isEnabled(MuleRuntimeFeature.DISABLE_JMX_FOR_COMMONS_POOL2)) {
            config.setJmxEnabled(false);
        }
        switch (this.poolingProfile.getExhaustedAction()) {
            case 2: {
                config.setMaxTotal(Integer.MAX_VALUE);
                config.setBlockWhenExhausted(false);
                break;
            }
            case 0: {
                config.setMaxTotal(this.poolingProfile.getMaxActive());
                config.setBlockWhenExhausted(false);
                break;
            }
            case 1: {
                config.setMaxTotal(this.poolingProfile.getMaxActive());
                config.setBlockWhenExhausted(true);
            }
        }
        config.setMaxWaitMillis(this.poolingProfile.getMaxWait());
        config.setMinEvictableIdleTimeMillis((long)this.poolingProfile.getMinEvictionMillis());
        config.setTimeBetweenEvictionRunsMillis((long)this.poolingProfile.getEvictionCheckIntervalMillis());
        GenericObjectPool genericPool = new GenericObjectPool((PooledObjectFactory)new ObjectFactoryAdapter(), config);
        LOGGER.debug("Creating pool with ID {} for config {}", (Object)this.poolId, (Object)ownerConfigName);
        this.applyInitialisationPolicy(genericPool);
        ConnectionUtils.logPoolStatus(LOGGER, genericPool, this.poolId);
        return genericPool;
    }

    protected void applyInitialisationPolicy(GenericObjectPool pool) {
        int initialConnections;
        switch (this.poolingProfile.getInitialisationPolicy()) {
            case 0: {
                initialConnections = 0;
                break;
            }
            case 1: {
                initialConnections = 1;
                break;
            }
            case 2: {
                if (this.poolingProfile.getMaxActive() < 0) {
                    initialConnections = this.poolingProfile.getMaxIdle();
                    break;
                }
                if (this.poolingProfile.getMaxIdle() < 0) {
                    initialConnections = this.poolingProfile.getMaxActive();
                    break;
                }
                initialConnections = Integer.min(this.poolingProfile.getMaxActive(), this.poolingProfile.getMaxIdle());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value for pooling profile initialization policy: " + this.poolingProfile.getInitialisationPolicy());
            }
        }
        LOGGER.debug("Initializing pool {} with {} initial connections", (Object)this.poolId, (Object)initialConnections);
        for (int t = 0; t < initialConnections; ++t) {
            try {
                pool.addObject();
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create a connection while applying the pool initialization policy.", (Throwable)e);
            }
        }
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    private class ObjectFactoryAdapter
    extends BasePooledObjectFactory<C> {
        private ObjectFactoryAdapter() {
        }

        public PooledObject<C> wrap(C obj) {
            return new DefaultPooledObject(obj);
        }

        public C create() throws Exception {
            Object connection = PoolingConnectionManagementStrategy.this.connectionProvider.connect();
            LOGGER.debug("Created connection {}", (Object)connection.toString());
            return connection;
        }

        public void destroyObject(PooledObject<C> connection) throws Exception {
            LOGGER.debug("Disconnecting connection {}", (Object)connection.getObject().toString());
            PoolingConnectionManagementStrategy.this.connectionProvider.disconnect(connection.getObject());
        }

        public boolean validateObject(PooledObject<C> obj) {
            return false;
        }
    }
}

