/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionRecoverer;
import org.mule.runtime.core.internal.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.AbstractQueueManager;
import org.mule.runtime.core.internal.util.queue.DefaultQueueStore;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueXaResourceManager;
import org.mule.runtime.core.internal.util.queue.RecoverableQueueStore;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueSession;
import org.mule.runtime.core.internal.util.xa.XaTransactionRecoverer;

public class TransactionalQueueManager
extends AbstractQueueManager {
    private LocalTxQueueTransactionJournal localTxTransactionJournal;
    private LocalTxQueueTransactionRecoverer localTxQueueTransactionRecoverer;
    private XaTxQueueTransactionJournal xaTransactionJournal;
    private XaTransactionRecoverer xaTransactionRecoverer;
    private final QueueXaResourceManager queueXaResourceManager = new QueueXaResourceManager();
    private final Map<String, RecoverableQueueStore> queuesAccessedForRecovery = new HashMap<String, RecoverableQueueStore>();

    @Override
    public QueueSession getQueueSession() {
        return new TransactionalQueueSession(this, this.queueXaResourceManager, this.queueXaResourceManager, this.xaTransactionRecoverer, this.localTxTransactionJournal, this.getMuleContext());
    }

    @Override
    protected DefaultQueueStore createQueueStore(String name, QueueConfiguration config) {
        return new DefaultQueueStore(name, this.getMuleContext(), config);
    }

    @Override
    protected void doDispose() {
        if (this.localTxTransactionJournal != null) {
            this.localTxTransactionJournal.close();
        }
        if (this.xaTransactionJournal != null) {
            this.xaTransactionJournal.close();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        String workingDirectory = this.getMuleContext().getConfiguration().getWorkingDirectory();
        int queueTransactionFilesSizeInMegabytes = this.getMuleContext().getConfiguration().getMaxQueueTransactionFilesSizeInMegabytes();
        this.localTxTransactionJournal = new LocalTxQueueTransactionJournal(workingDirectory + File.separator + "queue-tx-log", this.getMuleContext(), queueTransactionFilesSizeInMegabytes);
        this.localTxQueueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.localTxTransactionJournal, this);
        this.xaTransactionJournal = new XaTxQueueTransactionJournal(workingDirectory + File.separator + "queue-xa-tx-log", this.getMuleContext(), (Integer)queueTransactionFilesSizeInMegabytes);
        this.xaTransactionRecoverer = new XaTransactionRecoverer(this.xaTransactionJournal, this);
    }

    @Override
    public RecoverableQueueStore getRecoveryQueue(String queueName) {
        if (this.queuesAccessedForRecovery.containsKey(queueName)) {
            return this.queuesAccessedForRecovery.get(queueName);
        }
        DefaultQueueStore queueStore = this.createQueueStore(queueName, new DefaultQueueConfiguration(0, true));
        this.queuesAccessedForRecovery.put(queueName, queueStore);
        return queueStore;
    }

    @Override
    public void start() throws MuleException {
        this.queueXaResourceManager.start();
        this.localTxQueueTransactionRecoverer.recover();
        for (QueueStore queueStore : this.queuesAccessedForRecovery.values()) {
            queueStore.close();
        }
        this.queuesAccessedForRecovery.clear();
    }

    @Override
    public void stop() throws MuleException {
        this.queueXaResourceManager.stop();
    }
}

