/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class ClassLoaderModelAssembler {
    protected static final String CLASS_LOADER_MODEL_VERSION = "1.2.0";
    private final ArtifactCoordinates artifactCoordinates;
    private final List<BundleDependency> projectDependencies;
    private final Set<BundleDescriptor> sharedProjectDependencies;
    private final List<String> availablePackages;
    private final List<String> availableResources;

    public ClassLoaderModelAssembler(ArtifactCoordinates artifactCoordinates, List<BundleDependency> projectDependencies, Set<BundleDescriptor> sharedProjectDependencies, List<String> availablePackages, List<String> availableResources) {
        this.artifactCoordinates = Objects.requireNonNull(artifactCoordinates);
        this.projectDependencies = Objects.requireNonNull(projectDependencies);
        this.sharedProjectDependencies = Objects.requireNonNull(sharedProjectDependencies);
        this.availablePackages = Objects.requireNonNull(availablePackages);
        this.availableResources = Objects.requireNonNull(availableResources);
    }

    public ClassLoaderModel createClassLoaderModel() {
        ClassLoaderModel classLoaderModel = new ClassLoaderModel(CLASS_LOADER_MODEL_VERSION, this.getArtifactCoordinates());
        this.assembleClassLoaderModel(classLoaderModel);
        return classLoaderModel;
    }

    protected final void assembleClassLoaderModel(ClassLoaderModel classLoaderModel) {
        classLoaderModel.setDependencies(this.toArtifacts(this.projectDependencies));
        classLoaderModel.setPackages(this.availablePackages.toArray(new String[0]));
        classLoaderModel.setResources(this.availableResources.toArray(new String[0]));
    }

    private Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = this.toArtifactCoordinates(bundleDependency.getDescriptor());
        Artifact artifact = new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
        artifact.setPackages(bundleDependency.getPackages() == null ? new String[]{} : bundleDependency.getPackages().toArray(new String[0]));
        artifact.setResources(bundleDependency.getResources() == null ? new String[]{} : bundleDependency.getResources().toArray(new String[0]));
        if (this.sharedProjectDependencies.contains(bundleDependency.getDescriptor())) {
            artifact.setShared(true);
        }
        return artifact;
    }

    protected List<Artifact> toArtifacts(List<BundleDependency> dependencies) {
        return dependencies.stream().map(this::toArtifact).collect(Collectors.toList());
    }

    private ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        return new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), bundleDescriptor.getClassifier().orElse(null));
    }

    protected ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    protected List<BundleDependency> getProjectDependencies() {
        return this.projectDependencies;
    }
}

