/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingTargetTypeReferencesNonPropertyValue
extends AbstractErrorValidation {
    private final boolean enabled;

    public ErrorMappingTargetTypeReferencesNonPropertyValue(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "Error Type references fixed";
    }

    @Override
    public String getDescription() {
        return "Referenced error types are fixed.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        if (this.enabled) {
            return ComponentAstPredicatesFactory.currentElemement(this::errorMappingPresent);
        }
        return c -> false;
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        Iterator<ErrorMapping> iterator = ErrorMappingTargetTypeReferencesNonPropertyValue.getErrorMappings(component).iterator();
        if (iterator.hasNext()) {
            ErrorMapping errorMapping = iterator.next();
            String errorTypeRawValue = errorMapping.getTarget();
            if (MuleAstUtils.hasPropertyPlaceholder(errorTypeRawValue)) {
                return Optional.of(ValidationResultItem.create(component, component.getParameter("Error Mappings", "errorMappings"), (Validation)this, "'" + component.getIdentifier().getName() + "' has 'type' '" + errorTypeRawValue + "' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

