/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.async;

import java.util.concurrent.Executor;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.retry.async.FutureRetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWorker
implements Runnable {
    protected final transient Logger logger = LoggerFactory.getLogger(RetryWorker.class);
    private final RetryCallback callback;
    private final Executor workManager;
    private Exception exception = null;
    private final FutureRetryContext context = new FutureRetryContext();
    private final RetryPolicyTemplate delegate;
    private Latch startLatch;

    public RetryWorker(RetryPolicyTemplate delegate, RetryCallback callback, Executor workManager) {
        this(delegate, callback, workManager, null);
    }

    public RetryWorker(RetryPolicyTemplate delegate, RetryCallback callback, Executor workManager, Latch startLatch) {
        this.callback = callback;
        this.workManager = workManager;
        this.delegate = delegate;
        this.startLatch = startLatch;
        if (this.startLatch == null) {
            this.startLatch = new Latch();
            this.startLatch.countDown();
        }
    }

    @Override
    public void run() {
        try {
            this.startLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.warn("Retry thread interrupted for callback: " + this.callback.getWorkDescription());
            return;
        }
        try {
            this.context.setDelegateContext(this.delegate.execute(this.callback, this.workManager));
        }
        catch (Exception e) {
            this.exception = e;
            this.logger.error("Error retrying work", (Throwable)e);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public FutureRetryContext getRetryContext() {
        return this.context;
    }
}

