/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.artifact.ArtifactCoordinates;

public class ArtifactCoordinatesTypeAdapter
extends TypeAdapter<ArtifactCoordinates> {
    private static final String ARTIFACT_ID = "artifact id";
    private static final String GROUP_ID = "group id";
    private static final String VERSION = "version";

    public void write(JsonWriter out, ArtifactCoordinates value) throws IOException {
        if (value != null) {
            out.beginObject();
            out.name(ARTIFACT_ID).value(value.getArtifactId());
            out.name(GROUP_ID).value(value.getGroupId());
            out.name(VERSION).value(value.getVersion());
            out.endObject();
        }
    }

    public ArtifactCoordinates read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        return new ArtifactCoordinatesImpl(this.read(json, GROUP_ID), this.read(json, ARTIFACT_ID), this.read(json, VERSION));
    }

    private String read(JsonObject json, String memberName) {
        return json.get(memberName).getAsString();
    }

    private static class ArtifactCoordinatesImpl
    implements ArtifactCoordinates {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private ArtifactCoordinatesImpl(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }
}

