/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.InternalArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParserAttributesDTO;
import org.mule.runtime.ast.internal.serialization.json.gson.ArtifactAstSerializerMetadataAwareTypeAdapterFactory;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentLocationJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ErrorTypeJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ParserAttributesJsonTypeAdapter;
import org.mule.runtime.ast.internal.serialization.json.gson.PostProcessingEnabler;
import org.mule.runtime.ast.internal.serialization.resolver.DefaultGenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.NoOpGenerationInformationResolver;

public class JsonArtifactAstDeserializer
implements InternalArtifactAstDeserializer {
    private final Gson gson;
    private final String version;
    private final GenerationInformationResolver generationInformationResolver;

    public JsonArtifactAstDeserializer(GsonBuilder gsonBuilder, String version, boolean populateGenerationInformation) {
        gsonBuilder.registerTypeAdapter(ComponentIdentifier.class, (Object)new ComponentIdentifierJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ComponentLocation.class, (Object)new ComponentLocationJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ErrorType.class, (Object)new ErrorTypeJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ParserAttributesDTO.class, (Object)new ParserAttributesJsonTypeAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PostProcessingEnabler());
        this.gson = gsonBuilder.create();
        this.version = version;
        this.generationInformationResolver = populateGenerationInformation ? new DefaultGenerationInformationResolver() : new NoOpGenerationInformationResolver();
    }

    @Override
    public ArtifactAst deserialize(InputStream artifactAstInputStream, Charset charset, ExtensionModelResolver extensionModelResolver, ArtifactAst parent) {
        Gson gson = this.createGsonWithMetadata(new ArtifactAstSerializerMetadata("JSON", this.version, charset));
        ArtifactAstDTO artifactAstDTO = (ArtifactAstDTO)gson.fromJson((Reader)new BufferedReader(new InputStreamReader(artifactAstInputStream, charset)), ArtifactAstDTO.class);
        artifactAstDTO.setParent(parent);
        artifactAstDTO.enrich(extensionModelResolver, this.generationInformationResolver);
        return artifactAstDTO;
    }

    private Gson createGsonWithMetadata(ArtifactAstSerializerMetadata serializerMetadata) {
        return this.gson.newBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ArtifactAstSerializerMetadataAwareTypeAdapterFactory(serializerMetadata)).create();
    }
}

