/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.model;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;

public final class AggregatedImportsArtifactAst
extends BaseArtifactAst {
    private final Collection<ImportedResource> importedResources;
    private final Collection<ArtifactAst> importedConfigs;
    private final ArtifactAst parentArtifact;
    private final ArtifactAst base;
    private final LazyValue<Set<ExtensionModel>> dependencies;
    private final LazyValue<ErrorTypeRepository> errorTypeRepo;

    public AggregatedImportsArtifactAst(ArtifactAst parentArtifact, Collection<ImportedResource> importedResources, Collection<ArtifactAst> importedConfigs, ArtifactAst base) {
        this.parentArtifact = parentArtifact;
        this.importedResources = importedResources;
        this.importedConfigs = importedConfigs;
        this.base = base;
        this.dependencies = new LazyValue<Supplier<Set>>(() -> Stream.concat(base.dependencies().stream(), importedConfigs.stream().flatMap(ast -> ast.dependencies().stream())).collect(Collectors.toSet()));
        this.errorTypeRepo = new LazyValue<Supplier<ErrorTypeRepository>>(() -> {
            List<ErrorTypeRepository> allErrorTypeRepos = importedConfigs.stream().map(ArtifactAst::getErrorTypeRepository).collect(Collectors.toList());
            allErrorTypeRepos.add(0, base.getErrorTypeRepository());
            return new CompositeErrorTypeRepository(allErrorTypeRepos);
        });
    }

    @Override
    public String getArtifactName() {
        return this.base.getArtifactName();
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.base.getArtifactType();
    }

    @Override
    public Set<ExtensionModel> dependencies() {
        return this.dependencies.get();
    }

    @Override
    public Optional<ArtifactAst> getParent() {
        return Optional.ofNullable(this.parentArtifact);
    }

    @Override
    public Stream<ComponentAst> topLevelComponentsStream() {
        return Stream.concat(this.base.topLevelComponentsStream(), this.importedConfigs.stream().flatMap(ArtifactAst::topLevelComponentsStream));
    }

    @Override
    public List<ComponentAst> topLevelComponents() {
        return this.topLevelComponentsStream().collect(Collectors.toList());
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.base.updatePropertiesResolver(newPropertiesResolver);
        this.importedConfigs.forEach(ast -> ast.updatePropertiesResolver(newPropertiesResolver));
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepo.get();
    }

    @Override
    public NamespaceDefinition namespaceDefinition() {
        return this.base.namespaceDefinition();
    }

    @Override
    public Collection<ImportedResource> getImportedResources() {
        return this.importedResources;
    }
}

