/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.routing.UntilSuccessfulRouter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;

public class UntilSuccessful
extends AbstractMuleObjectOwner
implements Scope {
    private static final String DEFAULT_MILLIS_BETWEEN_RETRIES = "60000";
    private static final String DEFAULT_RETRIES = "5";
    public static final String UNTIL_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFIX = ":attempt";
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    private String maxRetries = "5";
    private String millisBetweenRetries = "60000";
    private MessageProcessorChain nestedChain;
    private boolean suppressErrors;
    private Predicate<CoreEvent> shouldRetry;
    private Scheduler timer;
    private List<Processor> processors;
    private ProcessingStrategy processingStrategy;

    @Override
    public void initialise() throws InitialisationException {
        if (this.processors == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("One message processor must be configured within 'until-successful'."), (Initialisable)this);
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this), this.processors, this.componentTracerFactory.fromComponent((Component)this, UNTIL_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFIX));
        super.initialise();
        this.timer = this.schedulerService.cpuLightScheduler();
        this.suppressErrors = this.featureFlaggingService.isEnabled(MuleRuntimeFeature.SUPPRESS_ERRORS);
        this.shouldRetry = event -> event.getError().isPresent();
        Optional<ProcessingStrategy> processingStrategyFromRootContainer = MessageProcessors.getProcessingStrategy(this.componentLocator, this);
        this.processingStrategy = processingStrategyFromRootContainer.orElseGet(() -> MessageProcessors.createDefaultProcessingStrategyFactory().create(this.muleContext, this.getLocation().getLocation() + ".ps"));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.stop();
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        try {
            return MessageProcessors.processToApply(event, this);
        }
        catch (Exception error) {
            Throwable cause = error.getCause();
            if (cause != null && cause instanceof UntilSuccessfulRouter.RetryContextInitializationException && cause.getCause() instanceof ExpressionRuntimeException) {
                throw (ExpressionRuntimeException)cause.getCause();
            }
            throw error;
        }
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return new UntilSuccessfulRouter(this, publisher, this.nestedChain, this.processingStrategy, this.expressionManager, this.shouldRetry, this.timer, this.maxRetries, this.millisBetweenRetries, this.suppressErrors).getDownstreamPublisher();
    }

    public String getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(String maxRetries) {
        this.maxRetries = maxRetries;
    }

    public String getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(String millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Object> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }
}

