/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.internal.profiling.tracing.DefaultComponentMetadata;
import org.mule.runtime.core.internal.profiling.tracing.DefaultExecutionContext;
import org.reactivestreams.Publisher;

public class PipelineProcessingStrategyReactiveProcessorBuilder {
    private final String artifactId;
    private final String artifactType;
    private final ReactiveProcessor pipeline;
    private final ClassLoader executionClassloader;
    private ScheduledExecutorService scheduler;
    private InternalProfilingService profilingService;

    private PipelineProcessingStrategyReactiveProcessorBuilder(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        this.pipeline = pipeline;
        this.executionClassloader = executionClassloader;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public static PipelineProcessingStrategyReactiveProcessorBuilder pipelineProcessingStrategyReactiveProcessorFrom(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        return new PipelineProcessingStrategyReactiveProcessorBuilder(pipeline, executionClassloader, artifactId, artifactType);
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withProfilingService(InternalProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ReactiveProcessor build() {
        return publisher -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)publisher)).build();
    }

    private <T extends Publisher> ReactorPublisherBuilder<T> baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder<T> publisher) {
        ComponentLocation location = ProfilingUtils.getLocation(this.pipeline);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> psSchedulingFlowExecutionDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> startingFlowExecutionDataproducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> flowExecutedDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.FLOW_EXECUTED);
        Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transformer = coreEvent -> new DefaultComponentProcessingStrategyProfilingEventContext((CoreEvent)coreEvent, location, Thread.currentThread().getName(), this.artifactId, this.artifactType, System.currentTimeMillis());
        return publisher.setTracingContext(this.profilingService, coreEvent -> new DefaultExecutionContext(new DefaultComponentMetadata(coreEvent.getCorrelationId(), this.artifactId, this.artifactType, location))).profileProcessingStrategyEvent(this.profilingService, psSchedulingFlowExecutionDataProducer, transformer).publishOn(Optional.ofNullable(this.scheduler)).profileProcessingStrategyEvent(this.profilingService, startingFlowExecutionDataproducer, transformer).doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).transform(this.pipeline).profileProcessingStrategyEvent(this.profilingService, flowExecutedDataProducer, transformer);
    }

    private ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> dataProducerFromProfilingService(ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType) {
        return this.profilingService.getProfilingDataProducer(profilingEventType);
    }
}

