/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class DefaultStereotypeEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){
            final Map<String, StereotypeModel> parentsCache = new HashMap<String, StereotypeModel>();
            final ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final String namespace = ExtensionNamespaceUtils.getExtensionsNamespace(this.extensionDeclaration);

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                this.assureHasStereotype(declaration, () -> this.createStereotype(this.namespace, declaration.getName(), MuleStereotypes.CONFIG));
            }

            @Override
            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                this.assureHasStereotype(declaration, () -> this.createStereotype(this.namespace, declaration.getName(), MuleStereotypes.CONNECTION));
            }

            @Override
            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                this.assureHasStereotype(declaration, () -> this.createComponentStereotype(this.namespace, declaration.getName(), MuleStereotypes.PROCESSOR));
            }

            @Override
            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                this.assureHasStereotype(declaration, () -> this.createComponentStereotype(this.namespace, declaration.getName(), MuleStereotypes.SOURCE));
            }

            private void assureHasStereotype(WithStereotypesDeclaration declaration, Supplier<StereotypeModel> defaultStereotype) {
                if (declaration.getStereotype() == null) {
                    declaration.withStereotype(defaultStereotype.get());
                }
            }

            private StereotypeModel createStereotype(String namespace, String name, StereotypeModel parent) {
                return StereotypeModelBuilder.newStereotype(name, namespace).withParent(parent).build();
            }

            private StereotypeModel createComponentStereotype(String namespace, String name, StereotypeModel parent) {
                if (!parent.getNamespace().equals(namespace)) {
                    StereotypeModel originalParent = parent;
                    parent = this.parentsCache.computeIfAbsent(parent.getType(), key -> StereotypeModelBuilder.newStereotype(originalParent.getType(), namespace).withParent(originalParent).build());
                }
                return this.createStereotype(namespace, name, parent);
            }
        });
    }
}

