/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.meter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.mule.runtime.metrics.api.instrument.builder.LongCounterBuilder;
import org.mule.runtime.metrics.api.instrument.builder.LongUpDownCounterBuilder;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.api.meter.builder.MeterBuilder;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.instrument.DefaultLongCounter;
import org.mule.runtime.metrics.impl.instrument.DefaultLongUpDownCounter;
import org.mule.runtime.metrics.impl.instrument.repository.InstrumentRepository;
import org.mule.runtime.metrics.impl.meter.builder.MeterBuilderWithRepository;
import org.mule.runtime.metrics.impl.meter.repository.MeterRepository;

public class DefaultMeter
implements Meter {
    private final MeterExporter meterExporter;
    private final Map<String, String> meterAttributes;
    private final String meterName;
    private final String description;
    private final InstrumentRepository instrumentRepository = new InstrumentRepository();

    public static MeterBuilderWithRepository builder(String meterName) {
        return new DefaultMeterBuilder(meterName);
    }

    public DefaultMeter(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
        this.meterName = meterName;
        this.description = description;
        this.meterExporter = meterExporter;
        this.meterAttributes = meterAttributes;
        meterExporter.registerMeterToExport(this);
    }

    @Override
    public String getName() {
        return this.meterName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.meterAttributes.forEach(biConsumer);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String counterName) {
        return DefaultLongUpDownCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    @Override
    public LongCounterBuilder counterBuilder(String counterName) {
        return DefaultLongCounter.builder(counterName, this).withInstrumentRepository(this.instrumentRepository).withMeterExporter(this.meterExporter);
    }

    private static class DefaultMeterBuilder
    implements MeterBuilderWithRepository {
        private final String meterName;
        private String description;
        private MeterRepository meterRepository;
        private MeterExporter meterExporter;
        private final Map<String, String> meterAttributes = new HashMap<String, String>();

        public DefaultMeterBuilder(String meterName) {
            this.meterName = meterName;
        }

        @Override
        public MeterBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public MeterBuilder withMeterAttribute(String key, String value) {
            this.meterAttributes.put(key, value);
            return this;
        }

        @Override
        public Meter build() {
            Objects.requireNonNull(this.meterExporter);
            return Optional.ofNullable(this.meterRepository).map(repository -> repository.create(this.meterName, name -> this.doBuild((String)name, this.description, this.meterExporter, this.meterAttributes))).orElse(this.doBuild(this.meterName, this.description, this.meterExporter, this.meterAttributes));
        }

        private Meter doBuild(String meterName, String description, MeterExporter meterExporter, Map<String, String> meterAttributes) {
            return new DefaultMeter(meterName, description, meterExporter, meterAttributes);
        }

        @Override
        public MeterBuilderWithRepository withMeterRepository(MeterRepository meterRepository) {
            this.meterRepository = meterRepository;
            return this;
        }

        @Override
        public MeterBuilderWithRepository withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }
    }
}

