/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonSerializer;

public class ComponentLocationJsonSerializer
implements JsonSerializer<ComponentLocation> {
    private final ComponentIdentifierJsonSerializer componentIdentifierJsonSerializer = new ComponentIdentifierJsonSerializer();

    public JsonElement serialize(ComponentLocation location, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonLocation = new JsonObject();
        jsonLocation.addProperty("name", location.getParts().get(0).getPartPath());
        JsonArray parts = new JsonArray();
        jsonLocation.add("parts", (JsonElement)parts);
        location.getParts().forEach(locationPart -> {
            JsonObject jsonLocationPart = this.serializeLocationPart(typeOfSrc, context, (LocationPart)locationPart);
            parts.add((JsonElement)jsonLocationPart);
        });
        jsonLocation.addProperty("location", location.getLocation());
        return jsonLocation;
    }

    protected JsonObject serializeLocationPart(Type typeOfSrc, JsonSerializationContext context, LocationPart locationPart) {
        JsonObject jsonLocationPart = new JsonObject();
        jsonLocationPart.addProperty("partPath", locationPart.getPartPath());
        locationPart.getPartIdentifier().ifPresent(partId -> {
            JsonObject partIdentifier = new JsonObject();
            partIdentifier.add("identifier", this.componentIdentifierJsonSerializer.serialize(partId.getIdentifier(), typeOfSrc, context));
            JsonObject type = new JsonObject();
            type.addProperty("name", partId.getType().name());
            partIdentifier.add("type", (JsonElement)type);
            jsonLocationPart.add("partIdentifier", (JsonElement)partIdentifier);
        });
        jsonLocationPart.addProperty("fileName", (String)locationPart.getFileName().orElse(null));
        locationPart.getLine().ifPresent(line -> jsonLocationPart.addProperty("line", (Number)line));
        locationPart.getColumn().ifPresent(column -> jsonLocationPart.addProperty("column", (Number)column));
        return jsonLocationPart;
    }
}

