/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.core.internal.util.ArrayUtils;

public class CompositeOptionalObjectsController
implements OptionalObjectsController {
    private final List<OptionalObjectsController> controllers;

    public CompositeOptionalObjectsController(OptionalObjectsController ... controllers) {
        Preconditions.checkArgument(!ArrayUtils.isEmpty((Object[])controllers), "cannot compose empty controllers list");
        this.controllers = ImmutableList.copyOf((Object[])controllers);
    }

    @Override
    public void registerOptionalKey(String key) {
        for (OptionalObjectsController controller : this.controllers) {
            controller.registerOptionalKey(key);
        }
    }

    @Override
    public void discardOptionalObject(String key) {
        for (OptionalObjectsController controller : this.controllers) {
            controller.discardOptionalObject(key);
        }
    }

    @Override
    public boolean isOptional(String key) {
        for (OptionalObjectsController controller : this.controllers) {
            if (!controller.isOptional(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDiscarded(String key) {
        for (OptionalObjectsController controller : this.controllers) {
            if (!controller.isDiscarded(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDiscardedObjectPlaceholder() {
        for (OptionalObjectsController controller : this.controllers) {
            Object placeHolder = controller.getDiscardedObjectPlaceholder();
            if (placeHolder == null) continue;
            return placeHolder;
        }
        return null;
    }

    @Override
    public Collection<String> getAllOptionalKeys() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (OptionalObjectsController controller : this.controllers) {
            builder.addAll(controller.getAllOptionalKeys());
        }
        return builder.build();
    }
}

