/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;

public class ContainerClassLoaderCreatorUtils {
    private static final String DEFAULT_JRE_EXTENSION_PACKAGES = "javax.,org.w3c.dom,org.omg.,org.xml.sax,org.ietf.jgss";
    private static final String MULE_SDK_API_PACKAGE = "org.mule.sdk.api";
    private static final String MULE_SDK_COMPATIBILITY_API_PACKAGE = "org.mule.sdk.compatibility.api";
    private static final String MULE_OAUTH_CLIENT_API_PACKAGE = "org.mule.runtime.oauth.api";
    private static final boolean ALLOW_JRE_EXTENSION = Boolean.parseBoolean(System.getProperty("mule.classloading.jreExtension", "true"));
    private static final String[] JRE_EXTENDABLE_PACKAGES = System.getProperty("mule.classloading.jreExtension.packages", "javax.,org.w3c.dom,org.omg.,org.xml.sax,org.ietf.jgss").split(",");
    public static final Set<String> SYSTEM_PACKAGES = ImmutableSet.of((Object)"org.mule.runtime", (Object)"com.mulesoft.mule.runtime");

    public static ClassLoaderLookupPolicy getLookupPolicy(ClassLoader parentClassLoader, List<MuleContainerModule> muleModules, Set<String> bootPackages) {
        HashSet<String> parentOnlyPackages = new HashSet<String>(bootPackages);
        parentOnlyPackages.addAll(SYSTEM_PACKAGES);
        Map<String, LookupStrategy> lookupStrategies = ContainerClassLoaderCreatorUtils.buildClassLoaderLookupStrategy(parentClassLoader, muleModules);
        return new MuleClassLoaderLookupPolicy(lookupStrategies, parentOnlyPackages);
    }

    private static Map<String, LookupStrategy> buildClassLoaderLookupStrategy(ClassLoader containerClassLoader, List<MuleContainerModule> modules) {
        Preconditions.checkArgument(containerClassLoader != null, "containerClassLoader cannot be null");
        Preconditions.checkArgument(modules != null, "modules cannot be null");
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(containerClassLoader);
        HashMap<String, LookupStrategy> result = new HashMap<String, LookupStrategy>();
        for (MuleContainerModule muleModule : modules) {
            Iterator<String> iterator = muleModule.getExportedPackages().iterator();
            while (iterator.hasNext()) {
                String exportedPackage;
                LookupStrategy specialLookupStrategy = ContainerClassLoaderCreatorUtils.getSpecialLookupStrategy(exportedPackage = iterator.next());
                result.put(exportedPackage, specialLookupStrategy == null ? containerOnlyLookupStrategy : specialLookupStrategy);
            }
        }
        return result;
    }

    private static LookupStrategy getSpecialLookupStrategy(String exportedPackage) {
        if (exportedPackage.startsWith(MULE_SDK_API_PACKAGE) || exportedPackage.startsWith(MULE_SDK_COMPATIBILITY_API_PACKAGE)) {
            return ParentFirstLookupStrategy.PARENT_FIRST;
        }
        if (exportedPackage.startsWith(MULE_OAUTH_CLIENT_API_PACKAGE)) {
            return ChildFirstLookupStrategy.CHILD_FIRST;
        }
        if (ALLOW_JRE_EXTENSION) {
            if (Arrays.stream(JRE_EXTENDABLE_PACKAGES).anyMatch(exportedPackage::startsWith)) {
                return ParentFirstLookupStrategy.PARENT_FIRST;
            }
        }
        return null;
    }
}

